/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.coll.MinHeapWithUpdate;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.EdgeBasedNodeContractor;
import com.graphhopper.routing.ch.EdgeBasedShortcutInserter;
import com.graphhopper.routing.ch.NodeBasedNodeContractor;
import com.graphhopper.routing.ch.NodeBasedShortcutHandler;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Locale;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareContractionHierarchies
extends AbstractAlgoPreparation {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CHConfig chConfig;
    private final CHGraph chGraph;
    private final Random rand = new Random(123L);
    private final StopWatch allSW = new StopWatch();
    private final StopWatch periodicUpdateSW = new StopWatch();
    private final StopWatch lazyUpdateSW = new StopWatch();
    private final StopWatch neighborUpdateSW = new StopWatch();
    private final StopWatch contractionSW = new StopWatch();
    private final Params params;
    private final Graph graph;
    private NodeContractor nodeContractor;
    private final int nodes;
    private NodeOrderingProvider nodeOrderingProvider;
    private int maxLevel;
    private MinHeapWithUpdate sortedNodes;
    private PMap pMap = new PMap();
    private int checkCounter;

    public static PrepareContractionHierarchies fromGraphHopperStorage(GraphHopperStorage ghStorage, CHConfig chConfig) {
        return new PrepareContractionHierarchies(ghStorage, chConfig);
    }

    private PrepareContractionHierarchies(GraphHopperStorage ghStorage, CHConfig chConfig) {
        TurnCostStorage turnCostStorage;
        this.graph = ghStorage;
        this.chGraph = ghStorage.getCHGraph(chConfig.getName());
        if (this.chGraph == null) {
            throw new IllegalArgumentException("There is no CH graph '" + chConfig.getName() + "', existing: " + ghStorage.getCHGraphNames());
        }
        this.chConfig = chConfig;
        this.params = Params.forTraversalMode(chConfig.getTraversalMode());
        this.nodes = this.chGraph.getNodes();
        if (chConfig.getTraversalMode().isEdgeBased() && (turnCostStorage = this.chGraph.getBaseGraph().getTurnCostStorage()) == null) {
            throw new IllegalArgumentException("For edge-based CH you need a turn cost storage");
        }
    }

    public PrepareContractionHierarchies setParams(PMap pMap) {
        this.pMap = pMap;
        this.params.setPeriodicUpdatesPercentage(pMap.getInt("prepare.ch.updates.periodic", this.params.getPeriodicUpdatesPercentage()));
        this.params.setLastNodesLazyUpdatePercentage(pMap.getInt("prepare.ch.updates.lazy", this.params.getLastNodesLazyUpdatePercentage()));
        this.params.setNeighborUpdatePercentage(pMap.getInt("prepare.ch.updates.neighbor", this.params.getNeighborUpdatePercentage()));
        this.params.setNodesContractedPercentage(pMap.getInt("prepare.ch.contracted_nodes", this.params.getNodesContractedPercentage()));
        this.params.setLogMessagesPercentage(pMap.getInt("prepare.ch.log_messages", this.params.getLogMessagesPercentage()));
        return this;
    }

    public PrepareContractionHierarchies useFixedNodeOrdering(NodeOrderingProvider nodeOrderingProvider) {
        if (nodeOrderingProvider.getNumNodes() != this.nodes) {
            throw new IllegalArgumentException("contraction order size (" + nodeOrderingProvider.getNumNodes() + ") must be equal to number of nodes in graph (" + this.nodes + ").");
        }
        this.nodeOrderingProvider = nodeOrderingProvider;
        return this;
    }

    @Override
    public void doSpecificWork() {
        if (!this.chGraph.isReadyForContraction()) {
            throw new IllegalStateException("Given CHGraph has not been frozen yet");
        }
        if (this.chGraph.getEdges() > this.chGraph.getOriginalEdges()) {
            throw new IllegalStateException("Given CHGraph has been contracted already");
        }
        this.allSW.start();
        this.initFromGraph();
        this.runGraphContraction();
        this.allSW.stop();
        this.logFinalGraphStats();
    }

    private void logFinalGraphStats() {
        int edgeCount = this.chGraph.getOriginalEdges();
        this.logger.info("took: {}s, graph now - num edges: {}, num nodes: {}, num shortcuts: {}", new Object[]{(int)this.allSW.getSeconds(), Helper.nf((long)edgeCount), Helper.nf((long)this.nodes), Helper.nf((long)(this.chGraph.getEdges() - edgeCount))});
    }

    private void runGraphContraction() {
        if (this.nodes < 1) {
            return;
        }
        this.setMaxLevelOnAllNodes();
        if (this.nodeOrderingProvider != null) {
            this.contractNodesUsingFixedNodeOrdering();
        } else {
            this.contractNodesUsingHeuristicNodeOrdering();
        }
    }

    public boolean isEdgeBased() {
        return this.chConfig.isEdgeBased();
    }

    private void initFromGraph() {
        CHPreparationGraph prepareGraph;
        if (this.chConfig.getTraversalMode().isEdgeBased()) {
            TurnCostStorage turnCostStorage = this.chGraph.getBaseGraph().getTurnCostStorage();
            if (turnCostStorage == null) {
                throw new IllegalArgumentException("For edge-based CH you need a turn cost storage");
            }
            this.logger.info("Creating CH prepare graph, {}", (Object)Helper.getMemInfo());
            CHPreparationGraph.TurnCostFunction turnCostFunction = CHPreparationGraph.buildTurnCostFunctionFromTurnCostStorage(this.graph, this.chConfig.getWeighting());
            prepareGraph = CHPreparationGraph.edgeBased(this.graph.getNodes(), this.graph.getEdges(), turnCostFunction);
            EdgeBasedShortcutInserter shortcutInserter = new EdgeBasedShortcutInserter(this.chGraph);
            this.nodeContractor = new EdgeBasedNodeContractor(prepareGraph, shortcutInserter, this.pMap);
        } else {
            this.logger.info("Creating CH prepare graph, {}", (Object)Helper.getMemInfo());
            prepareGraph = CHPreparationGraph.nodeBased(this.graph.getNodes(), this.graph.getEdges());
            NodeBasedShortcutHandler shortcutInserter = new NodeBasedShortcutHandler(this.chGraph);
            this.nodeContractor = new NodeBasedNodeContractor(prepareGraph, shortcutInserter, this.pMap);
        }
        this.maxLevel = this.nodes;
        this.sortedNodes = new MinHeapWithUpdate(prepareGraph.getNodes());
        this.logger.info("Building CH prepare graph, {}", (Object)Helper.getMemInfo());
        StopWatch sw = new StopWatch().start();
        CHPreparationGraph.buildFromGraph(prepareGraph, this.graph, this.getWeighting());
        this.logger.info("Finished building CH prepare graph, took: {}s, {}", (Object)Float.valueOf(sw.stop().getSeconds()), (Object)Helper.getMemInfo());
        this.nodeContractor.initFromGraph();
    }

    private void setMaxLevelOnAllNodes() {
        for (int node = 0; node < this.nodes; ++node) {
            this.chGraph.setLevel(node, this.maxLevel);
        }
    }

    private void updatePrioritiesOfRemainingNodes() {
        this.periodicUpdateSW.start();
        this.sortedNodes.clear();
        for (int node = 0; node < this.nodes; ++node) {
            if (this.isContracted(node)) continue;
            float priority = this.calculatePriority(node);
            this.sortedNodes.push(node, priority);
        }
        this.periodicUpdateSW.stop();
    }

    private void contractNodesUsingHeuristicNodeOrdering() {
        boolean neighborUpdate;
        StopWatch sw = new StopWatch().start();
        this.logger.info("Building initial queue of nodes to be contracted: {} nodes, {}", (Object)this.nodes, (Object)Helper.getMemInfo());
        this.updatePrioritiesOfRemainingNodes();
        this.logger.info("Finished building queue, took: {}s, {}", (Object)Float.valueOf(sw.stop().getSeconds()), (Object)Helper.getMemInfo());
        this.nodeContractor.prepareContraction();
        int initSize = this.sortedNodes.size();
        int level = 0;
        this.checkCounter = 0;
        long logSize = this.params.getLogMessagesPercentage() == 0 ? Long.MAX_VALUE : Math.round(Math.max(10.0, (double)initSize * ((double)this.params.getLogMessagesPercentage() / 100.0)));
        long periodicUpdatesCount = this.params.getPeriodicUpdatesPercentage() == 0 ? Long.MAX_VALUE : Math.round(Math.max(10.0, (double)initSize * ((double)this.params.getPeriodicUpdatesPercentage() / 100.0)));
        int updateCounter = 0;
        long lastNodesLazyUpdates = Math.round((double)initSize * ((double)this.params.getLastNodesLazyUpdatePercentage() / 100.0));
        long nodesToAvoidContract = Math.round((double)initSize * ((double)(100 - this.params.getNodesContractedPercentage()) / 100.0));
        boolean bl = neighborUpdate = this.params.getNeighborUpdatePercentage() != 0;
        while (!this.sortedNodes.isEmpty()) {
            this.stopIfInterrupted();
            if (this.checkCounter > 0 && (long)this.checkCounter % periodicUpdatesCount == 0L) {
                this.updatePrioritiesOfRemainingNodes();
                ++updateCounter;
                if (this.sortedNodes.isEmpty()) {
                    throw new IllegalStateException("Cannot prepare as no unprepared nodes where found. Called preparation twice?");
                }
            }
            if ((long)this.checkCounter % logSize == 0L) {
                this.logHeuristicStats(updateCounter);
            }
            ++this.checkCounter;
            int polledNode = this.sortedNodes.poll();
            if (!this.sortedNodes.isEmpty() && (long)this.sortedNodes.size() < lastNodesLazyUpdates) {
                this.lazyUpdateSW.start();
                float priority = this.calculatePriority(polledNode);
                if (priority > this.sortedNodes.peekValue()) {
                    this.sortedNodes.push(polledNode, priority);
                    this.lazyUpdateSW.stop();
                    continue;
                }
                this.lazyUpdateSW.stop();
            }
            IntContainer neighbors = this.contractNode(polledNode, level);
            ++level;
            if ((long)this.sortedNodes.size() < nodesToAvoidContract) break;
            for (IntCursor neighbor : neighbors) {
                int nn = neighbor.value;
                if (!neighborUpdate || this.rand.nextInt(100) >= this.params.getNeighborUpdatePercentage()) continue;
                this.neighborUpdateSW.start();
                float priority = this.calculatePriority(nn);
                this.sortedNodes.update(nn, priority);
                this.neighborUpdateSW.stop();
            }
        }
        this.nodeContractor.finishContraction();
        this.logHeuristicStats(updateCounter);
        this.logger.info("new shortcuts: " + Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()) + ", initSize:" + Helper.nf((long)initSize) + ", " + this.chConfig.getWeighting() + ", periodic:" + this.params.getPeriodicUpdatesPercentage() + ", lazy:" + this.params.getLastNodesLazyUpdatePercentage() + ", neighbor:" + this.params.getNeighborUpdatePercentage() + ", " + this.getTimesAsString() + ", lazy-overhead: " + (int)(100.0 * ((double)this.checkCounter / (double)initSize - 1.0)) + "%, " + Helper.getMemInfo());
        this._close();
    }

    private void contractNodesUsingFixedNodeOrdering() {
        this.nodeContractor.prepareContraction();
        int nodesToContract = this.nodeOrderingProvider.getNumNodes();
        int logSize = Math.max(10, (int)((double)this.params.getLogMessagesPercentage() / 100.0 * (double)nodesToContract));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (int i = 0; i < nodesToContract; ++i) {
            this.stopIfInterrupted();
            int node = this.nodeOrderingProvider.getNodeIdForLevel(i);
            this.contractNode(node, i);
            if (i % logSize != 0) continue;
            stopWatch.stop();
            this.logFixedNodeOrderingStats(i, logSize, stopWatch);
            stopWatch.start();
        }
        this.nodeContractor.finishContraction();
    }

    private void stopIfInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("Thread was interrupted");
        }
    }

    private IntContainer contractNode(int node, int level) {
        if (this.isContracted(node)) {
            throw new IllegalArgumentException("Node " + node + " was contracted already");
        }
        this.contractionSW.start();
        IntContainer neighbors = this.nodeContractor.contractNode(node);
        this.chGraph.setLevel(node, level);
        this.contractionSW.stop();
        return neighbors;
    }

    private boolean isContracted(int node) {
        return this.chGraph.getLevel(node) != this.maxLevel;
    }

    private void logHeuristicStats(int updateCounter) {
        this.logger.info(String.format(Locale.ROOT, "%s, nodes: %10s, shortcuts: %10s, updates: %2d, checked-nodes: %10s, %s, %s, %s", this.isEdgeBased() ? "edge" : "node", Helper.nf((long)this.sortedNodes.size()), Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()), updateCounter, Helper.nf((long)this.checkCounter), this.getTimesAsString(), this.nodeContractor.getStatisticsString(), Helper.getMemInfo()));
    }

    private void logFixedNodeOrderingStats(int nodesContracted, int logSize, StopWatch stopWatch) {
        this.logger.info(String.format(Locale.ROOT, "nodes: %10s / %10s (%6.2f%%), shortcuts: %10s, speed = %6.2f nodes/ms, %s, %s", Helper.nf((long)nodesContracted), Helper.nf((long)this.nodes), 100.0 * (double)nodesContracted / (double)this.nodes, Helper.nf((long)this.nodeContractor.getAddedShortcutsCount()), nodesContracted == 0 ? 0.0 : (double)logSize / (double)stopWatch.getMillis(), this.nodeContractor.getStatisticsString(), Helper.getMemInfo()));
    }

    public long getDijkstraCount() {
        return this.nodeContractor.getDijkstraCount();
    }

    public long getShortcuts() {
        return this.nodeContractor.getAddedShortcutsCount();
    }

    public double getLazyTime() {
        return this.lazyUpdateSW.getCurrentSeconds();
    }

    public double getPeriodTime() {
        return this.periodicUpdateSW.getCurrentSeconds();
    }

    public double getNeighborTime() {
        return this.neighborUpdateSW.getCurrentSeconds();
    }

    public Weighting getWeighting() {
        return this.chConfig.getWeighting();
    }

    public CHConfig getCHConfig() {
        return this.chConfig;
    }

    private String getTimesAsString() {
        float totalTime = this.allSW.getCurrentSeconds();
        float periodicUpdateTime = this.periodicUpdateSW.getCurrentSeconds();
        float lazyUpdateTime = this.lazyUpdateSW.getCurrentSeconds();
        float neighborUpdateTime = this.neighborUpdateSW.getCurrentSeconds();
        float contractionTime = this.contractionSW.getCurrentSeconds();
        float otherTime = totalTime - (periodicUpdateTime + lazyUpdateTime + neighborUpdateTime + contractionTime);
        float dijkstraTime = this.nodeContractor.getDijkstraSeconds();
        return String.format(Locale.ROOT, "t(total): %6.2f,  t(period): %6.2f, t(lazy): %6.2f, t(neighbor): %6.2f, t(contr): %6.2f, t(other) : %6.2f, dijkstra-ratio: %6.2f%%", Float.valueOf(totalTime), Float.valueOf(periodicUpdateTime), Float.valueOf(lazyUpdateTime), Float.valueOf(neighborUpdateTime), Float.valueOf(contractionTime), Float.valueOf(otherTime), Float.valueOf(dijkstraTime / totalTime * 100.0f));
    }

    public long getTotalPrepareTime() {
        return this.allSW.getMillis();
    }

    private float calculatePriority(int node) {
        if (this.isContracted(node)) {
            throw new IllegalArgumentException("Priority should only be calculated for not yet contracted nodes");
        }
        return this.nodeContractor.calculatePriority(node);
    }

    public String toString() {
        return this.chConfig.isEdgeBased() ? "prepare|dijkstrabi|edge|ch" : "prepare|dijkstrabi|ch";
    }

    private void _close() {
        this.nodeContractor.close();
        this.sortedNodes = null;
    }

    void close() {
        CHGraphImpl cg = (CHGraphImpl)this.chGraph;
        cg.flush();
        cg.close();
    }

    private static class Params {
        private int periodicUpdatesPercentage;
        private int lastNodesLazyUpdatePercentage;
        private int neighborUpdatePercentage;
        private int nodesContractedPercentage;
        private int logMessagesPercentage;

        static Params forTraversalMode(TraversalMode traversalMode) {
            if (traversalMode.isEdgeBased()) {
                return new Params(0, 100, 0, 100, 5);
            }
            return new Params(20, 10, 20, 100, 20);
        }

        private Params(int periodicUpdatesPercentage, int lastNodesLazyUpdatePercentage, int neighborUpdatePercentage, int nodesContractedPercentage, int logMessagesPercentage) {
            this.setPeriodicUpdatesPercentage(periodicUpdatesPercentage);
            this.setLastNodesLazyUpdatePercentage(lastNodesLazyUpdatePercentage);
            this.setNeighborUpdatePercentage(neighborUpdatePercentage);
            this.setNodesContractedPercentage(nodesContractedPercentage);
            this.setLogMessagesPercentage(logMessagesPercentage);
        }

        int getPeriodicUpdatesPercentage() {
            return this.periodicUpdatesPercentage;
        }

        void setPeriodicUpdatesPercentage(int periodicUpdatesPercentage) {
            this.checkPercentage("prepare.ch.updates.periodic", periodicUpdatesPercentage);
            this.periodicUpdatesPercentage = periodicUpdatesPercentage;
        }

        int getLastNodesLazyUpdatePercentage() {
            return this.lastNodesLazyUpdatePercentage;
        }

        void setLastNodesLazyUpdatePercentage(int lastNodesLazyUpdatePercentage) {
            this.checkPercentage("prepare.ch.updates.lazy", lastNodesLazyUpdatePercentage);
            this.lastNodesLazyUpdatePercentage = lastNodesLazyUpdatePercentage;
        }

        int getNeighborUpdatePercentage() {
            return this.neighborUpdatePercentage;
        }

        void setNeighborUpdatePercentage(int neighborUpdatePercentage) {
            this.checkPercentage("prepare.ch.updates.neighbor", neighborUpdatePercentage);
            this.neighborUpdatePercentage = neighborUpdatePercentage;
        }

        int getNodesContractedPercentage() {
            return this.nodesContractedPercentage;
        }

        void setNodesContractedPercentage(int nodesContractedPercentage) {
            this.checkPercentage("prepare.ch.contracted_nodes", nodesContractedPercentage);
            this.nodesContractedPercentage = nodesContractedPercentage;
        }

        int getLogMessagesPercentage() {
            return this.logMessagesPercentage;
        }

        void setLogMessagesPercentage(int logMessagesPercentage) {
            this.checkPercentage("prepare.ch.log_messages", logMessagesPercentage);
            this.logMessagesPercentage = logMessagesPercentage;
        }

        private void checkPercentage(String name, int value) {
            if (value < 0 || value > 100) {
                throw new IllegalArgumentException(name + " has to be in [0, 100], to disable it use 0");
            }
        }
    }
}

