/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import java.util.Arrays;

public class MinHeapWithUpdate {
    private static final int NOT_PRESENT = -1;
    private final int[] tree;
    private final int[] positions;
    private final float[] vals;
    private final int max;
    private int size;

    public MinHeapWithUpdate(int elements) {
        this.tree = new int[elements + 1];
        this.positions = new int[elements + 1];
        Arrays.fill(this.positions, -1);
        this.vals = new float[elements + 1];
        this.vals[0] = Float.NEGATIVE_INFINITY;
        this.max = elements;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void push(int id, float value) {
        this.checkIdInRange(id);
        if (this.size == this.max) {
            throw new IllegalStateException("Cannot push anymore, the heap is already full. size: " + this.size);
        }
        if (this.contains(id)) {
            throw new IllegalStateException("Element with id: " + id + " was pushed already, you need to use the update method if you want to change its value");
        }
        ++this.size;
        this.tree[this.size] = id;
        this.positions[id] = this.size;
        this.vals[this.size] = value;
        this.percolateUp(this.size);
    }

    public boolean contains(int id) {
        this.checkIdInRange(id);
        return this.positions[id] != -1;
    }

    public void update(int id, float value) {
        this.checkIdInRange(id);
        int index = this.positions[id];
        if (index < 0) {
            throw new IllegalStateException("The heap does not contain: " + id + ". Use the contains method to check this before calling update");
        }
        float prev = this.vals[index];
        this.vals[index] = value;
        if (value > prev) {
            this.percolateDown(index);
        } else if (value < prev) {
            this.percolateUp(index);
        }
    }

    public int peekId() {
        return this.tree[1];
    }

    public float peekValue() {
        return this.vals[1];
    }

    public int poll() {
        int id = this.peekId();
        this.tree[1] = this.tree[this.size];
        this.vals[1] = this.vals[this.size];
        this.positions[this.tree[1]] = 1;
        this.positions[id] = -1;
        --this.size;
        this.percolateDown(1);
        return id;
    }

    public void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.positions[this.tree[i]] = -1;
        }
        this.size = 0;
    }

    private void percolateUp(int index) {
        assert (index != 0);
        if (index == 1) {
            return;
        }
        int el = this.tree[index];
        float val = this.vals[index];
        while (val < this.vals[index >> 1]) {
            int parent = index >> 1;
            this.tree[index] = this.tree[parent];
            this.vals[index] = this.vals[parent];
            this.positions[this.tree[index]] = index;
            index = parent;
        }
        this.tree[index] = el;
        this.vals[index] = val;
        this.positions[this.tree[index]] = index;
    }

    private void percolateDown(int index) {
        if (this.size == 0) {
            return;
        }
        assert (index > 0);
        assert (index <= this.size);
        int el = this.tree[index];
        float val = this.vals[index];
        while (index << 1 <= this.size) {
            int child = index << 1;
            if (child != this.size && this.vals[child + 1] < this.vals[child]) {
                ++child;
            }
            if (this.vals[child] >= val) break;
            this.tree[index] = this.tree[child];
            this.vals[index] = this.vals[child];
            this.positions[this.tree[index]] = index;
            index = child;
        }
        this.tree[index] = el;
        this.vals[index] = val;
        this.positions[this.tree[index]] = index;
    }

    private void checkIdInRange(int id) {
        if (id < 0 || id >= this.max) {
            throw new IllegalArgumentException("Illegal id: " + id + ", legal range: [0, " + this.max + "[");
        }
    }
}

