/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.List;

public class OSMBikeNetworkTagParser
implements RelationTagParser {
    private EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    private EnumEncodedValue<RouteNetwork> transformerRouteRelEnc;

    @Override
    public void createRelationEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        this.transformerRouteRelEnc = new EnumEncodedValue<RouteNetwork>(EncodingManager.getKey("bike", "route_relation"), RouteNetwork.class);
        registerNewEncodedValue.add(this.transformerRouteRelEnc);
    }

    @Override
    public IntsRef handleRelationTags(IntsRef relFlags, ReaderRelation relation) {
        RouteNetwork oldBikeNetwork = this.transformerRouteRelEnc.getEnum(false, relFlags);
        if (relation.hasTag("route", (Object)"bicycle")) {
            String tag = Helper.toLowerCase((String)relation.getTag("network", ""));
            RouteNetwork newBikeNetwork = RouteNetwork.LOCAL;
            if ("lcn".equals(tag)) {
                newBikeNetwork = RouteNetwork.LOCAL;
            } else if ("rcn".equals(tag)) {
                newBikeNetwork = RouteNetwork.REGIONAL;
            } else if ("ncn".equals(tag)) {
                newBikeNetwork = RouteNetwork.NATIONAL;
            } else if ("icn".equals(tag)) {
                newBikeNetwork = RouteNetwork.INTERNATIONAL;
            }
            if (oldBikeNetwork == RouteNetwork.OTHER || oldBikeNetwork.ordinal() > newBikeNetwork.ordinal()) {
                this.transformerRouteRelEnc.setEnum(false, relFlags, newBikeNetwork);
            }
        }
        return relFlags;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        this.bikeRouteEnc = new EnumEncodedValue<RouteNetwork>(RouteNetwork.key("bike"), RouteNetwork.class);
        registerNewEncodedValue.add(this.bikeRouteEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        RouteNetwork routeNetwork = this.transformerRouteRelEnc.getEnum(false, relationFlags);
        this.bikeRouteEnc.setEnum(false, edgeFlags, routeNetwork);
        return edgeFlags;
    }
}

