/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LandmarkSuggestion {
    private List<Integer> nodeIds;
    private BBox box;

    public LandmarkSuggestion(List<Integer> nodeIds, BBox box) {
        this.nodeIds = nodeIds;
        this.box = box;
    }

    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }

    public BBox getBox() {
        return this.box;
    }

    public static final LandmarkSuggestion readLandmarks(String file, LocationIndex locationIndex) throws IOException {
        EdgeFilter edgeFilter = EdgeFilter.ALL_EDGES;
        List lines = Helper.readFile((String)file);
        ArrayList<Integer> landmarkNodeIds = new ArrayList<Integer>();
        BBox bbox = BBox.createInverse(false);
        int lmSuggestionIdx = 0;
        String errors = "";
        for (String lmStr : lines) {
            if (lmStr.startsWith("#BBOX:")) {
                bbox = BBox.parseTwoPoints(lmStr.substring("#BBOX:".length()));
                continue;
            }
            if (lmStr.isEmpty() || Character.isAlphabetic(lmStr.charAt(0))) continue;
            GHPoint point = GHPoint.fromStringLonLat((String)lmStr);
            if (point == null) {
                throw new RuntimeException("Invalid format " + lmStr + " for point " + lmSuggestionIdx);
            }
            ++lmSuggestionIdx;
            Snap result = locationIndex.findClosest(point.lat, point.lon, edgeFilter);
            if (!result.isValid()) {
                errors = errors + "Cannot find close node found for landmark suggestion[" + lmSuggestionIdx + "]=" + point + ".\n";
                continue;
            }
            bbox.update(point.lat, point.lon);
            landmarkNodeIds.add(result.getClosestNode());
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException(errors);
        }
        return new LandmarkSuggestion(landmarkNodeIds, bbox);
    }
}

