/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class RoutingAlgorithmFactorySimple
implements RoutingAlgorithmFactory {
    @Override
    public RoutingAlgorithm createAlgo(Graph g, AlgorithmOptions opts) {
        RoutingAlgorithm ra;
        String algoStr = opts.getAlgorithm();
        Weighting weighting = g.wrapWeighting(opts.getWeighting());
        if ("dijkstrabi".equalsIgnoreCase(algoStr)) {
            ra = new DijkstraBidirectionRef(g, weighting, opts.getTraversalMode());
        } else if ("dijkstra".equalsIgnoreCase(algoStr)) {
            ra = new Dijkstra(g, weighting, opts.getTraversalMode());
        } else if ("astarbi".equalsIgnoreCase(algoStr) || Helper.isEmpty((String)algoStr)) {
            AStarBidirection aStarBi = new AStarBidirection(g, weighting, opts.getTraversalMode());
            aStarBi.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts.getHints(), weighting, g.getNodeAccess()));
            ra = aStarBi;
        } else if ("dijkstra_one_to_many".equalsIgnoreCase(algoStr)) {
            ra = new DijkstraOneToMany(g, weighting, opts.getTraversalMode());
        } else if ("astar".equalsIgnoreCase(algoStr)) {
            AStar aStar = new AStar(g, weighting, opts.getTraversalMode());
            aStar.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astar", opts.getHints(), opts.getWeighting(), g.getNodeAccess()));
            ra = aStar;
        } else if ("alternative_route".equalsIgnoreCase(algoStr)) {
            AlternativeRoute altRouteAlgo = new AlternativeRoute(g, weighting, opts.getTraversalMode());
            altRouteAlgo.setMaxPaths(opts.getHints().getInt("alternative_route.max_paths", 2));
            altRouteAlgo.setMaxWeightFactor(opts.getHints().getDouble("alternative_route.max_weight_factor", 1.4));
            altRouteAlgo.setMaxShareFactor(opts.getHints().getDouble("alternative_route.max_share_factor", 0.6));
            altRouteAlgo.setMinPlateauFactor(opts.getHints().getDouble("alternative_route.min_plateau_factor", 0.2));
            altRouteAlgo.setMaxExplorationFactor(opts.getHints().getDouble("alternative_route.max_exploration_factor", 1.0));
            ra = altRouteAlgo;
        } else {
            throw new IllegalArgumentException("Algorithm " + algoStr + " not found in " + this.getClass().getName());
        }
        ra.setMaxVisitedNodes(opts.getMaxVisitedNodes());
        return ra;
    }

    public static WeightApproximator getApproximation(String prop, PMap opts, Weighting weighting, NodeAccess na) {
        String approxAsStr = opts.getString(prop + ".approximation", "BeelineSimplification");
        double epsilon = opts.getDouble(prop + ".epsilon", 1.0);
        BeelineWeightApproximator approx = new BeelineWeightApproximator(na, weighting);
        approx.setEpsilon(epsilon);
        if ("BeelineSimplification".equals(approxAsStr)) {
            approx.setDistanceCalc(DistancePlaneProjection.DIST_PLANE);
        } else if ("BeelineAccurate".equals(approxAsStr)) {
            approx.setDistanceCalc(DistanceCalcEarth.DIST_EARTH);
        } else {
            throw new IllegalArgumentException("Approximation " + approxAsStr + " not found in " + RoutingAlgorithmFactorySimple.class.getName());
        }
        return approx;
    }
}

