/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MiniPerfTest {
    private static final double NS_PER_S = 1.0E9;
    private static final double NS_PER_MS = 1000000.0;
    private static final double NS_PER_US = 1000.0;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private int counts = 100;
    private long fullTime = 0L;
    private long max;
    private long min = Long.MAX_VALUE;
    private int dummySum;

    public MiniPerfTest start() {
        int warmupCount = Math.max(1, this.counts / 3);
        for (int i = 0; i < warmupCount; ++i) {
            this.dummySum += this.doCalc(true, i);
        }
        long startFull = System.nanoTime();
        for (int i = 0; i < this.counts; ++i) {
            long start = System.nanoTime();
            this.dummySum += this.doCalc(false, i);
            long time = System.nanoTime() - start;
            if (time < this.min) {
                this.min = time;
            }
            if (time <= this.max) continue;
            this.max = time;
        }
        this.fullTime = System.nanoTime() - startFull;
        this.logger.info("dummySum:" + this.dummySum);
        return this;
    }

    public MiniPerfTest setIterations(int counts) {
        this.counts = counts;
        return this;
    }

    public double getMin() {
        return (double)this.min / 1000000.0;
    }

    public double getMax() {
        return (double)this.max / 1000000.0;
    }

    public double getSum() {
        return (double)this.fullTime / 1000000.0;
    }

    public double getMean() {
        return this.getSum() / (double)this.counts;
    }

    private String formatDuration(double durationNs) {
        String unit;
        double divisor;
        if (durationNs > 1.0E7) {
            divisor = 1.0E9;
            unit = "s";
        } else if (durationNs > 10000.0) {
            divisor = 1000000.0;
            unit = "ms";
        } else {
            divisor = 1000.0;
            unit = "us";
        }
        return this.nf(durationNs / divisor) + unit;
    }

    public String getReport() {
        double meanNs = (double)this.fullTime / (double)this.counts;
        return "sum:" + this.formatDuration(this.fullTime) + ", time/call:" + this.formatDuration(meanNs);
    }

    public int getDummySum() {
        return this.dummySum;
    }

    private String nf(Number num) {
        return new DecimalFormat("#.###", DecimalFormatSymbols.getInstance(Locale.ROOT)).format(num);
    }

    public abstract int doCalc(boolean var1, int var2);
}

