/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;

public class RoutingCHEdgeIteratorStateImpl
implements RoutingCHEdgeIteratorState {
    private final EdgeIteratorState edgeState;
    private final Weighting weighting;
    private final BooleanEncodedValue accessEnc;

    public RoutingCHEdgeIteratorStateImpl(EdgeIteratorState edgeState, Weighting weighting) {
        this.edgeState = edgeState;
        this.weighting = weighting;
        this.accessEnc = weighting.getFlagEncoder().getAccessEnc();
    }

    @Override
    public EdgeIteratorState getBaseGraphEdgeState() {
        if (this.isShortcut()) {
            throw new IllegalStateException("Base edge can only be obtained for original edges, was: " + this.edgeState());
        }
        return this.edgeState();
    }

    @Override
    public int getEdge() {
        return this.edgeState().getEdge();
    }

    @Override
    public int getOrigEdgeFirst() {
        return this.edgeState().getOrigEdgeFirst();
    }

    @Override
    public int getOrigEdgeLast() {
        return this.edgeState().getOrigEdgeLast();
    }

    @Override
    public int getBaseNode() {
        return this.edgeState().getBaseNode();
    }

    @Override
    public int getAdjNode() {
        return this.edgeState().getAdjNode();
    }

    @Override
    public boolean isShortcut() {
        return this.edgeState() instanceof CHEdgeIteratorState && ((CHEdgeIteratorState)this.edgeState()).isShortcut();
    }

    @Override
    public int getSkippedEdge1() {
        return ((CHEdgeIteratorState)this.edgeState()).getSkippedEdge1();
    }

    @Override
    public int getSkippedEdge2() {
        return ((CHEdgeIteratorState)this.edgeState()).getSkippedEdge2();
    }

    @Override
    public double getWeight(boolean reverse) {
        if (this.isShortcut()) {
            return ((CHEdgeIteratorState)this.edgeState()).getWeight();
        }
        return this.getOrigEdgeWeight(reverse, true);
    }

    double getOrigEdgeWeight(boolean reverse, boolean needWeight) {
        boolean access;
        EdgeIteratorState baseEdge = this.getBaseGraphEdgeState();
        boolean bl = access = reverse ? baseEdge.getReverse(this.accessEnc) : baseEdge.get(this.accessEnc);
        if (baseEdge.getBaseNode() != baseEdge.getAdjNode() && !access) {
            return Double.POSITIVE_INFINITY;
        }
        if (!needWeight) {
            return 0.0;
        }
        return this.weighting.calcEdgeWeight(baseEdge, reverse);
    }

    EdgeIteratorState edgeState() {
        return this.edgeState;
    }
}

