/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

abstract class EdgeAccess {
    private static final int NO_NODE = -1;
    final DataAccess edges;
    int E_NODEA;
    int E_NODEB;
    int E_LINKA;
    int E_LINKB;
    int E_FLAGS;

    EdgeAccess(DataAccess edges) {
        this.edges = edges;
    }

    final void init(int E_NODEA, int E_NODEB, int E_LINKA, int E_LINKB, int E_FLAGS) {
        this.E_NODEA = E_NODEA;
        this.E_NODEB = E_NODEB;
        this.E_LINKA = E_LINKA;
        this.E_LINKB = E_LINKB;
        this.E_FLAGS = E_FLAGS;
    }

    abstract long toPointer(int var1);

    abstract boolean isInBounds(int var1);

    abstract int getEdgeRef(int var1);

    abstract void setEdgeRef(int var1, int var2);

    abstract int getEntryBytes();

    final void invalidateEdge(long edgePointer) {
        this.edges.setInt(edgePointer + (long)this.E_NODEB, -1);
    }

    static boolean isInvalidNodeB(int node) {
        return node == -1;
    }

    final void readFlags(long edgePointer, IntsRef edgeFlags) {
        int size = edgeFlags.ints.length;
        for (int i = 0; i < size; ++i) {
            edgeFlags.ints[i] = this.edges.getInt(edgePointer + (long)this.E_FLAGS + (long)(i * 4));
        }
    }

    final void writeFlags(long edgePointer, IntsRef edgeFlags) {
        int size = edgeFlags.ints.length;
        for (int i = 0; i < size; ++i) {
            this.edges.setInt(edgePointer + (long)this.E_FLAGS + (long)(i * 4), edgeFlags.ints[i]);
        }
    }

    final int internalEdgeAdd(int newEdgeId, int nodeA, int nodeB) {
        this.writeEdge(newEdgeId, nodeA, nodeB, -1, -1);
        long edgePointer = this.toPointer(newEdgeId);
        int edge = this.getEdgeRef(nodeA);
        if (edge > -1) {
            this.edges.setInt((long)this.E_LINKA + edgePointer, edge);
        }
        this.setEdgeRef(nodeA, newEdgeId);
        if (nodeA != nodeB) {
            edge = this.getEdgeRef(nodeB);
            if (edge > -1) {
                this.edges.setInt((long)this.E_LINKB + edgePointer, edge);
            }
            this.setEdgeRef(nodeB, newEdgeId);
        }
        return newEdgeId;
    }

    final int getNodeA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEA);
    }

    final int getNodeB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEB);
    }

    final int getLinkA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKA);
    }

    final int getLinkB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKB);
    }

    final int getOtherNode(int nodeThis, long edgePointer) {
        int nodeA = this.getNodeA(edgePointer);
        return nodeThis == nodeA ? this.getNodeB(edgePointer) : nodeA;
    }

    final boolean isAdjacentToNode(int node, long edgePointer) {
        return this.getNodeA(edgePointer) == node || this.getNodeB(edgePointer) == node;
    }

    final long writeEdge(int edgeId, int nodeA, int nodeB, int nextEdgeA, int nextEdgeB) {
        if (!EdgeIterator.Edge.isValid(edgeId)) {
            throw new IllegalStateException("Cannot write edge with illegal ID:" + edgeId + "; nodeA:" + nodeA + ", nodeB:" + nodeB);
        }
        long edgePointer = this.toPointer(edgeId);
        this.edges.setInt(edgePointer + (long)this.E_NODEA, nodeA);
        this.edges.setInt(edgePointer + (long)this.E_NODEB, nodeB);
        this.edges.setInt(edgePointer + (long)this.E_LINKA, nextEdgeA);
        this.edges.setInt(edgePointer + (long)this.E_LINKB, nextEdgeB);
        return edgePointer;
    }

    final long internalEdgeDisconnect(int edgeToRemove, long edgeToUpdatePointer, int baseNode) {
        int nextEdgeId;
        long edgeToRemovePointer = this.toPointer(edgeToRemove);
        int n = nextEdgeId = this.getNodeA(edgeToRemovePointer) == baseNode ? this.getLinkA(edgeToRemovePointer) : this.getLinkB(edgeToRemovePointer);
        if (edgeToUpdatePointer < 0L) {
            this.setEdgeRef(baseNode, nextEdgeId);
        } else {
            long link = this.getNodeA(edgeToUpdatePointer) == baseNode ? edgeToUpdatePointer + (long)this.E_LINKA : edgeToUpdatePointer + (long)this.E_LINKB;
            this.edges.setInt(link, nextEdgeId);
        }
        return edgeToRemovePointer;
    }

    abstract EdgeIteratorState getEdgeProps(int var1, int var2, EdgeFilter var3);
}

