/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.weighting.custom.DecimalToValueEntry;
import com.graphhopper.routing.weighting.custom.EdgeToValueEntry;
import com.graphhopper.routing.weighting.custom.EnumToValueEntry;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Map;

final class IntToValueEntry
implements EdgeToValueEntry {
    private final IntEncodedValue iev;
    private final double minExclusive;
    private final double maxExclusive;
    private final double rangeValue;
    private final double fallback;

    private IntToValueEntry(IntEncodedValue iev, DecimalToValueEntry.Range range, double fallback) {
        this.iev = iev;
        this.minExclusive = range.min;
        this.maxExclusive = range.max;
        this.rangeValue = range.value;
        this.fallback = fallback;
    }

    @Override
    public double getValue(EdgeIteratorState iter, boolean reverse) {
        double edgeValue = iter.get(this.iev);
        return edgeValue < this.maxExclusive && edgeValue > this.minExclusive ? this.rangeValue : this.fallback;
    }

    static EdgeToValueEntry create(String name, IntEncodedValue dev, Map<String, Object> map, double defaultValue, double minValue, double maxValue) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty map for " + name);
        }
        Object evEntryValue = map.get("*");
        if (evEntryValue != null) {
            defaultValue = EnumToValueEntry.getReturnValue(name, "*", evEntryValue, minValue, maxValue);
        }
        ArrayList<DecimalToValueEntry.Range> ranges = new ArrayList<DecimalToValueEntry.Range>();
        for (Map.Entry<String, Object> encValEntry : map.entrySet()) {
            if (encValEntry.getKey() == null) {
                throw new IllegalArgumentException("key for " + name + " cannot be null, value: " + encValEntry.getValue());
            }
            String key = encValEntry.getKey();
            if ("*".equals(key)) continue;
            double returnValue = EnumToValueEntry.getReturnValue(name, key, encValEntry.getValue(), minValue, maxValue);
            DecimalToValueEntry.Range range = DecimalToValueEntry.parseRange(name, key, returnValue);
            ranges.add(range);
        }
        if (ranges.size() != 1) {
            throw new IllegalArgumentException("Currently only one range can be specified but was " + ranges.size());
        }
        return new IntToValueEntry(dev, (DecimalToValueEntry.Range)ranges.get(0), defaultValue);
    }

    public String toString() {
        return this.iev.getName() + ", range: min:" + this.minExclusive + ", max:" + this.maxExclusive + ", value:" + this.rangeValue;
    }
}

