/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.AbstractAdjustedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.util.EdgeIteratorState;

public class BlockAreaWeighting
extends AbstractAdjustedWeighting {
    private GraphEdgeIdFinder.BlockArea blockArea;

    public BlockAreaWeighting(Weighting superWeighting, GraphEdgeIdFinder.BlockArea blockArea) {
        super(superWeighting);
        this.blockArea = blockArea;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        if (this.blockArea.intersects(edgeState)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.superWeighting.calcEdgeWeight(edgeState, reverse);
    }

    @Override
    public String getName() {
        return "block_area";
    }
}

