/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;

public class BeelineWeightApproximator
implements WeightApproximator {
    private final NodeAccess nodeAccess;
    private final Weighting weighting;
    private DistanceCalc distanceCalc = Helper.DIST_EARTH;
    private double toLat;
    private double toLon;
    private double epsilon = 1.0;

    public BeelineWeightApproximator(NodeAccess nodeAccess, Weighting weighting) {
        this.nodeAccess = nodeAccess;
        this.weighting = weighting;
    }

    @Override
    public void setTo(int toNode) {
        this.toLat = this.nodeAccess.getLatitude(toNode);
        this.toLon = this.nodeAccess.getLongitude(toNode);
    }

    public WeightApproximator setEpsilon(double epsilon) {
        this.epsilon = epsilon;
        return this;
    }

    @Override
    public WeightApproximator reverse() {
        return new BeelineWeightApproximator(this.nodeAccess, this.weighting).setDistanceCalc(this.distanceCalc).setEpsilon(this.epsilon);
    }

    @Override
    public double getSlack() {
        return 0.0;
    }

    @Override
    public double approximate(int fromNode) {
        double fromLat = this.nodeAccess.getLatitude(fromNode);
        double fromLon = this.nodeAccess.getLongitude(fromNode);
        double dist2goal = this.distanceCalc.calcDist(this.toLat, this.toLon, fromLat, fromLon);
        double weight2goal = this.weighting.getMinWeight(dist2goal);
        return weight2goal * this.epsilon;
    }

    public BeelineWeightApproximator setDistanceCalc(DistanceCalc distanceCalc) {
        this.distanceCalc = distanceCalc;
        return this;
    }

    public String toString() {
        return "beeline";
    }
}

