/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.spatialrules.SpatialRuleSet;
import com.graphhopper.routing.util.spatialrules.TransportationMode;
import com.graphhopper.storage.IntsRef;
import java.util.List;

public class OSMMaxSpeedParser
implements TagParser {
    protected final DecimalEncodedValue carMaxSpeedEnc;

    public OSMMaxSpeedParser() {
        this(MaxSpeed.create());
    }

    public OSMMaxSpeedParser(DecimalEncodedValue carMaxSpeedEnc) {
        if (!carMaxSpeedEnc.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue for maxSpeed must be able to store two directions");
        }
        this.carMaxSpeedEnc = carMaxSpeedEnc;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.carMaxSpeedEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        double bwdSpeed;
        double maxPossibleSpeed;
        double fwdSpeed;
        double maxSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed"));
        SpatialRuleSet spatialRuleSet = way.getTag("spatial_rule_set", null);
        if (spatialRuleSet != null && spatialRuleSet != SpatialRuleSet.EMPTY) {
            RoadClass roadClass = RoadClass.find(way.getTag("highway", ""));
            maxSpeed = spatialRuleSet.getMaxSpeed(roadClass, TransportationMode.MOTOR_VEHICLE, maxSpeed);
        }
        if ((fwdSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed:forward"))) < 0.0 && maxSpeed > 0.0) {
            fwdSpeed = maxSpeed;
        }
        if (fwdSpeed > (maxPossibleSpeed = 150.0)) {
            fwdSpeed = maxPossibleSpeed;
        }
        if ((bwdSpeed = AbstractFlagEncoder.parseSpeed(way.getTag("maxspeed:backward"))) < 0.0 && maxSpeed > 0.0) {
            bwdSpeed = maxSpeed;
        }
        if (bwdSpeed > maxPossibleSpeed) {
            bwdSpeed = maxPossibleSpeed;
        }
        if (fwdSpeed <= 0.0) {
            fwdSpeed = Double.POSITIVE_INFINITY;
        }
        this.carMaxSpeedEnc.setDecimal(false, edgeFlags, fwdSpeed);
        if (bwdSpeed <= 0.0) {
            bwdSpeed = Double.POSITIVE_INFINITY;
        }
        this.carMaxSpeedEnc.setDecimal(true, edgeFlags, bwdSpeed);
        return edgeFlags;
    }
}

