/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.OSMTurnRelation;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.BikeCommonFlagEncoder;
import com.graphhopper.routing.util.DefaultFlagEncoderFactory;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMFootNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMGetOffBikeParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassLinkParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.OSMTurnRelationParser;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.routing.util.parsers.SpatialRuleParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.util.parsers.TurnCostParser;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class EncodingManager
implements EncodedValueLookup {
    private static final Pattern WAY_NAME_PATTERN = Pattern.compile("; *");
    private final List<AbstractFlagEncoder> edgeEncoders = new ArrayList<AbstractFlagEncoder>();
    private final Map<String, EncodedValue> encodedValueMap = new LinkedHashMap<String, EncodedValue>();
    private final List<RelationTagParser> relationTagParsers = new ArrayList<RelationTagParser>();
    private final List<TagParser> edgeTagParsers = new ArrayList<TagParser>();
    private final Map<String, TurnCostParser> turnCostParsers = new LinkedHashMap<String, TurnCostParser>();
    private int nextNodeBit = 0;
    private boolean enableInstructions = true;
    private String preferredLanguage = "";
    private EncodedValue.InitializerConfig turnCostConfig = new EncodedValue.InitializerConfig();
    private EncodedValue.InitializerConfig relationConfig = new EncodedValue.InitializerConfig();
    private EncodedValue.InitializerConfig edgeConfig = new EncodedValue.InitializerConfig();
    private static final String SPECIAL_SEPARATOR = ".";

    public static EncodingManager create(String flagEncodersStr) {
        return EncodingManager.create(new DefaultFlagEncoderFactory(), flagEncodersStr);
    }

    public static EncodingManager create(FlagEncoderFactory factory, String flagEncodersStr) {
        return EncodingManager.createBuilder(EncodingManager.parseEncoderString(factory, flagEncodersStr)).build();
    }

    public static EncodingManager create(FlagEncoder ... flagEncoders) {
        return EncodingManager.create(Arrays.asList(flagEncoders));
    }

    public static EncodingManager create(List<? extends FlagEncoder> flagEncoders) {
        return EncodingManager.createBuilder(flagEncoders).build();
    }

    private static Builder createBuilder(List<? extends FlagEncoder> flagEncoders) {
        Builder builder = new Builder();
        for (FlagEncoder flagEncoder : flagEncoders) {
            builder.add(flagEncoder);
        }
        return builder;
    }

    public static EncodingManager create(EncodedValueFactory evFactory, FlagEncoderFactory flagEncoderFactory, String ghLoc) {
        String flagEncoderValuesStr;
        RAMDirectory dir = new RAMDirectory(ghLoc, true);
        StorableProperties properties = new StorableProperties(dir);
        if (!properties.loadExisting()) {
            throw new IllegalStateException("Cannot load properties to fetch EncodingManager configuration at: " + dir.getLocation());
        }
        Builder builder = new Builder();
        String encodedValuesStr = properties.get("graph.encoded_values");
        if (!Helper.isEmpty((String)encodedValuesStr)) {
            builder.addAll(evFactory, encodedValuesStr);
        }
        if (!Helper.isEmpty((String)(flagEncoderValuesStr = properties.get("graph.flag_encoders")))) {
            builder.addAll(flagEncoderFactory, flagEncoderValuesStr);
        }
        if (Helper.isEmpty((String)flagEncoderValuesStr) && Helper.isEmpty((String)encodedValuesStr)) {
            throw new IllegalStateException("EncodingManager was not configured. And no one was found in the graph: " + dir.getLocation());
        }
        return builder.build();
    }

    public static Builder start() {
        return new Builder();
    }

    private EncodingManager() {
    }

    public void releaseParsers() {
        this.turnCostParsers.clear();
        this.edgeTagParsers.clear();
        this.relationTagParsers.clear();
    }

    static List<FlagEncoder> parseEncoderString(FlagEncoderFactory factory, String encoderList) {
        if (encoderList.contains(":")) {
            throw new IllegalArgumentException("EncodingManager does no longer use reflection instantiate encoders directly.");
        }
        if (!encoderList.equals(Helper.toLowerCase((String)encoderList))) {
            throw new IllegalArgumentException("Since 0.7 EncodingManager does no longer accept upper case profiles: " + encoderList);
        }
        String[] entries = encoderList.split(",");
        ArrayList<FlagEncoder> resultEncoders = new ArrayList<FlagEncoder>();
        for (String entry : entries) {
            if ((entry = Helper.toLowerCase((String)entry.trim())).isEmpty()) continue;
            String entryVal = "";
            if (entry.contains("|")) {
                entryVal = entry;
                entry = entry.split("\\|")[0];
            }
            PMap configuration = new PMap(entryVal);
            resultEncoders.add(factory.createFlagEncoder(entry, configuration));
        }
        return resultEncoders;
    }

    private void add(List<EncodedValue> returnList, EncodedValueFactory factory, String evList) {
        if (!evList.equals(Helper.toLowerCase((String)evList))) {
            throw new IllegalArgumentException("Use lower case for EncodedValues: " + evList);
        }
        for (String entry : evList.split(",")) {
            if ((entry = Helper.toLowerCase((String)entry.trim())).isEmpty()) continue;
            EncodedValue evObject = factory.create(entry);
            PMap map = new PMap(entry);
            if (!map.has("version")) {
                throw new IllegalArgumentException("encoded value must have a version specified but it was " + entry);
            }
            returnList.add(evObject);
        }
    }

    private void add(List<TagParser> returnList, TagParserFactory factory, String tpList) {
        if (!tpList.equals(Helper.toLowerCase((String)tpList))) {
            throw new IllegalArgumentException("Use lower case for TagParser: " + tpList);
        }
        for (String entry : tpList.split(",")) {
            if ((entry = entry.trim()).isEmpty()) continue;
            PMap map = new PMap(entry);
            TagParser tp = factory.create(entry, map);
            returnList.add(tp);
        }
    }

    static String fixWayName(String str) {
        if (str == null) {
            return "";
        }
        return WAY_NAME_PATTERN.matcher(str).replaceAll(", ");
    }

    public int getIntsForFlags() {
        return (int)Math.ceil((double)this.edgeConfig.getRequiredBits() / 32.0);
    }

    private void setEnableInstructions(boolean enableInstructions) {
        this.enableInstructions = enableInstructions;
    }

    public boolean isEnableInstructions() {
        return this.enableInstructions;
    }

    private void setPreferredLanguage(String preferredLanguage) {
        if (preferredLanguage == null) {
            throw new IllegalArgumentException("preferred language cannot be null");
        }
        this.preferredLanguage = preferredLanguage;
    }

    private void addEncoder(AbstractFlagEncoder encoder) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.toString().equals(encoder.toString())) continue;
            throw new IllegalArgumentException("Cannot register edge encoder. Name already exists: " + flagEncoder.toString());
        }
        int encoderCount = this.edgeEncoders.size();
        int n = encoder.defineNodeBits(encoderCount, this.nextNodeBit);
        encoder.setNodeBitMask(n - this.nextNodeBit, this.nextNodeBit);
        this.nextNodeBit = n;
        encoder.setEncodedValueLookup(this);
        ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
        encoder.createEncodedValues(list, encoder.toString(), encoderCount);
        for (EncodedValue ev : list) {
            this.addEncodedValue(ev, true);
        }
        this.edgeEncoders.add(encoder);
    }

    private void addEncodedValue(EncodedValue ev, boolean withNamespace) {
        if (this.hasEncodedValue(ev.getName())) {
            throw new IllegalStateException("EncodedValue " + ev.getName() + " already exists " + this.encodedValueMap.get(ev.getName()) + " vs " + ev);
        }
        if (!withNamespace && !this.isSharedEV(ev)) {
            throw new IllegalArgumentException("EncodedValue " + ev.getName() + " must not contain namespace character '" + SPECIAL_SEPARATOR + "'");
        }
        if (withNamespace && this.isSharedEV(ev)) {
            throw new IllegalArgumentException("EncodedValue " + ev.getName() + " must contain namespace character '" + SPECIAL_SEPARATOR + "'");
        }
        ev.init(this.edgeConfig);
        this.encodedValueMap.put(ev.getName(), ev);
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueMap.get(key) != null;
    }

    public boolean hasEncoder(String encoder) {
        return this.getEncoder(encoder, false) != null;
    }

    public FlagEncoder getEncoder(String name) {
        return this.getEncoder(name, true);
    }

    private FlagEncoder getEncoder(String name, boolean throwExc) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!name.equalsIgnoreCase(flagEncoder.toString())) continue;
            return flagEncoder;
        }
        if (throwExc) {
            throw new IllegalArgumentException("Encoder for " + name + " not found. Existing: " + this.toFlagEncodersAsString());
        }
        return null;
    }

    public boolean acceptWay(ReaderWay way, AcceptWay acceptWay) {
        if (!acceptWay.isEmpty()) {
            throw new IllegalArgumentException("AcceptWay must be empty");
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            acceptWay.put(encoder.toString(), encoder.getAccess(way));
        }
        return acceptWay.hasAccepted();
    }

    public IntsRef handleRelationTags(ReaderRelation relation, IntsRef relFlags) {
        for (RelationTagParser relParser : this.relationTagParsers) {
            relParser.handleRelationTags(relFlags, relation);
        }
        return relFlags;
    }

    public void handleTurnRelationTags(OSMTurnRelation turnRelation, TurnCostParser.ExternalInternalMap map, Graph graph) {
        for (TurnCostParser parser : this.turnCostParsers.values()) {
            parser.handleTurnRelationTags(turnRelation, map, graph);
        }
    }

    public IntsRef handleWayTags(ReaderWay way, AcceptWay acceptWay, IntsRef relationFlags) {
        IntsRef edgeFlags = this.createEdgeFlags();
        for (TagParser parser : this.edgeTagParsers) {
            parser.handleWayTags(edgeFlags, way, acceptWay.isFerry(), relationFlags);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.handleWayTags(edgeFlags, way, acceptWay.get(encoder.toString()));
        }
        return edgeFlags;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(flagEncoder.toString());
        }
        return str.toString();
    }

    public String toFlagEncodersAsString() {
        StringBuilder str = new StringBuilder();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(encoder.toString()).append("|").append(encoder.getPropertiesString()).append("|version=").append(encoder.getVersion());
        }
        return str.toString();
    }

    public String toEncodedValuesAsString() {
        StringBuilder str = new StringBuilder();
        for (EncodedValue ev : this.encodedValueMap.values()) {
            if (!this.isSharedEV(ev)) continue;
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(ev.toString());
        }
        return str.toString();
    }

    public IntsRef createEdgeFlags() {
        return new IntsRef(this.getIntsForFlags());
    }

    public IntsRef createRelationFlags() {
        return new IntsRef(2);
    }

    public IntsRef flagsDefault(boolean forward, boolean backward) {
        IntsRef intsRef = this.createEdgeFlags();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.flagsDefault(intsRef, forward, backward);
        }
        return intsRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingManager that = (EncodingManager)o;
        return this.enableInstructions == that.enableInstructions && this.edgeEncoders.equals(that.edgeEncoders) && this.encodedValueMap.equals(that.encodedValueMap) && this.preferredLanguage.equals(that.preferredLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.edgeEncoders, this.encodedValueMap, this.enableInstructions, this.preferredLanguage);
    }

    public long handleNodeTags(ReaderNode node) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleNodeTags(node);
        }
        return flags;
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        if (this.enableInstructions) {
            String refName;
            String name = "";
            if (!this.preferredLanguage.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name:" + this.preferredLanguage));
            }
            if (name.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name"));
            }
            if (!(refName = EncodingManager.fixWayName(way.getTag("ref"))).isEmpty()) {
                name = name.isEmpty() ? refName : name + ", " + refName;
            }
            edge.setName(name);
        }
        if (Double.isInfinite(edge.getDistance())) {
            throw new IllegalStateException("Infinite distance should not happen due to #435. way ID=" + way.getId());
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.applyWayTags(way, edge);
        }
    }

    public List<FlagEncoder> fetchEdgeEncoders() {
        return new ArrayList<FlagEncoder>(this.edgeEncoders);
    }

    public boolean needsTurnCostsSupport() {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.supportsTurnCosts()) continue;
            return true;
        }
        return false;
    }

    public List<BooleanEncodedValue> getAccessEncFromNodeFlags(long importNodeFlags) {
        ArrayList<BooleanEncodedValue> list = new ArrayList<BooleanEncodedValue>(this.edgeEncoders.size());
        for (int i = 0; i < this.edgeEncoders.size(); ++i) {
            FlagEncoder encoder = this.edgeEncoders.get(i);
            if ((1L << i & importNodeFlags) == 0L) continue;
            list.add(encoder.getAccessEnc());
        }
        return list;
    }

    @Override
    public List<EncodedValue> getAllShared() {
        ArrayList<EncodedValue> list = new ArrayList<EncodedValue>(this.encodedValueMap.size());
        for (EncodedValue ev : this.encodedValueMap.values()) {
            if (!this.isSharedEV(ev)) continue;
            list.add(ev);
        }
        return list;
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.getEncodedValue(key, BooleanEncodedValue.class);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.getEncodedValue(key, IntEncodedValue.class);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.getEncodedValue(key, DecimalEncodedValue.class);
    }

    @Override
    public <T extends Enum> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> type) {
        return this.getEncodedValue(key, EnumEncodedValue.class);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.encodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find EncodedValue " + key + " in collection: " + ev);
        }
        return (T)ev;
    }

    private boolean isSharedEV(EncodedValue ev) {
        return !ev.getName().contains(SPECIAL_SEPARATOR);
    }

    public static String getKey(FlagEncoder encoder, String str) {
        return EncodingManager.getKey(encoder.toString(), str);
    }

    public static String getKey(String prefix, String str) {
        return prefix + SPECIAL_SEPARATOR + str;
    }

    public static enum Access {
        WAY,
        FERRY,
        OTHER,
        CAN_SKIP;


        public boolean isFerry() {
            return this.ordinal() == FERRY.ordinal();
        }

        public boolean isWay() {
            return this.ordinal() == WAY.ordinal();
        }

        public boolean isOther() {
            return this.ordinal() == OTHER.ordinal();
        }

        public boolean canSkip() {
            return this.ordinal() == CAN_SKIP.ordinal();
        }
    }

    public static class AcceptWay {
        private Map<String, Access> accessMap = new HashMap<String, Access>(5);
        boolean hasAccepted = false;
        boolean isFerry = false;

        private Access get(String key) {
            Access res = this.accessMap.get(key);
            if (res == null) {
                throw new IllegalArgumentException("Couldn't fetch Access value for encoder key " + key);
            }
            return res;
        }

        public AcceptWay put(String key, Access access) {
            this.accessMap.put(key, access);
            if (access != Access.CAN_SKIP) {
                this.hasAccepted = true;
            }
            if (access == Access.FERRY) {
                this.isFerry = true;
            }
            return this;
        }

        public boolean isEmpty() {
            return this.accessMap.isEmpty();
        }

        public boolean hasAccepted() {
            return this.hasAccepted;
        }

        public boolean isFerry() {
            return this.isFerry;
        }
    }

    public static class Builder {
        private EncodingManager em;
        private DateRangeParser dateRangeParser;
        private List<AbstractFlagEncoder> flagEncoderList = new ArrayList<AbstractFlagEncoder>();
        private List<EncodedValue> encodedValueList = new ArrayList<EncodedValue>();
        private List<TagParser> tagParsers = new ArrayList<TagParser>();
        private List<TurnCostParser> turnCostParsers = new ArrayList<TurnCostParser>();
        private List<RelationTagParser> relationTagParsers = new ArrayList<RelationTagParser>();

        public Builder() {
            this.em = new EncodingManager();
        }

        public Builder setPreferredLanguage(String language) {
            this.check();
            this.em.setPreferredLanguage(language);
            return this;
        }

        public Builder setEnableInstructions(boolean enable) {
            this.check();
            this.em.setEnableInstructions(enable);
            return this;
        }

        public Builder addAll(FlagEncoderFactory factory, String flagEncodersStr) {
            this.check();
            for (FlagEncoder fe : EncodingManager.parseEncoderString(factory, flagEncodersStr)) {
                this.flagEncoderList.add((AbstractFlagEncoder)fe);
            }
            return this;
        }

        public Builder addAll(EncodedValueFactory factory, String encodedValueString) {
            this.check();
            this.em.add(this.encodedValueList, factory, encodedValueString);
            return this;
        }

        public Builder addAll(TagParserFactory factory, String tagParserString) {
            this.check();
            this.em.add(this.tagParsers, factory, tagParserString);
            return this;
        }

        public Builder addTurnCostParser(TurnCostParser parser) {
            this.check();
            this.turnCostParsers.add(parser);
            return this;
        }

        public Builder addRelationTagParser(RelationTagParser tagParser) {
            this.check();
            this.relationTagParsers.add(tagParser);
            return this;
        }

        public Builder add(FlagEncoder encoder) {
            this.check();
            this.flagEncoderList.add((AbstractFlagEncoder)encoder);
            return this;
        }

        public Builder add(EncodedValue encodedValue) {
            this.check();
            this.encodedValueList.add(encodedValue);
            return this;
        }

        public Builder setDateRangeParser(DateRangeParser dateRangeParser) {
            this.check();
            this.dateRangeParser = dateRangeParser;
            return this;
        }

        public Builder add(TagParser tagParser) {
            this.check();
            this.tagParsers.add(tagParser);
            return this;
        }

        private void check() {
            if (this.em == null) {
                throw new IllegalStateException("Cannot call method after Builder.build() was called");
            }
        }

        private void _addEdgeTagParser(TagParser tagParser, boolean withNamespace, boolean insert) {
            if (!this.em.edgeEncoders.isEmpty()) {
                throw new IllegalStateException("Avoid mixing encoded values from FlagEncoder with shared encoded values until we have a more clever mechanism, see #1862");
            }
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            tagParser.createEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                this.em.addEncodedValue(ev, withNamespace);
            }
            if (insert) {
                this.em.edgeTagParsers.add(0, tagParser);
            } else {
                this.em.edgeTagParsers.add(tagParser);
            }
        }

        private void _addRelationTagParser(RelationTagParser tagParser) {
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            tagParser.createRelationEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                ev.init(this.em.relationConfig);
            }
            this.em.relationTagParsers.add(tagParser);
            this._addEdgeTagParser(tagParser, false, false);
        }

        private void _addTurnCostParser(TurnCostParser parser) {
            ArrayList<EncodedValue> list = new ArrayList<EncodedValue>();
            parser.createTurnCostEncodedValues(this.em, list);
            for (EncodedValue ev : list) {
                ev.init(this.em.turnCostConfig);
                if (this.em.encodedValueMap.containsKey(ev.getName())) {
                    throw new IllegalArgumentException("Already defined: " + ev.getName() + ". Please note that EncodedValues for edges and turn cost are in the same namespace.");
                }
                this.em.encodedValueMap.put(ev.getName(), ev);
            }
            this.em.turnCostParsers.put(parser.getName(), parser);
        }

        public EncodingManager build() {
            this.check();
            for (RelationTagParser relationTagParser : this.relationTagParsers) {
                this._addRelationTagParser(relationTagParser);
            }
            ArrayList<SpatialRuleParser> insertLater = new ArrayList<SpatialRuleParser>();
            for (TagParser tagParser : this.tagParsers) {
                if (SpatialRuleParser.class.isAssignableFrom(tagParser.getClass())) {
                    insertLater.add((SpatialRuleParser)tagParser);
                    continue;
                }
                this._addEdgeTagParser(tagParser, false, false);
            }
            for (EncodedValue encodedValue : this.encodedValueList) {
                this.em.addEncodedValue(encodedValue, false);
            }
            if (!this.em.hasEncodedValue("roundabout")) {
                this._addEdgeTagParser(new OSMRoundaboutParser(), false, false);
            }
            if (!this.em.hasEncodedValue("road_class")) {
                this._addEdgeTagParser(new OSMRoadClassParser(), false, false);
            }
            if (!this.em.hasEncodedValue("road_class_link")) {
                this._addEdgeTagParser(new OSMRoadClassLinkParser(), false, false);
            }
            if (!this.em.hasEncodedValue("road_environment")) {
                this._addEdgeTagParser(new OSMRoadEnvironmentParser(), false, false);
            }
            if (!this.em.hasEncodedValue("max_speed")) {
                this._addEdgeTagParser(new OSMMaxSpeedParser(), false, false);
            }
            if (!this.em.hasEncodedValue("road_access")) {
                this._addEdgeTagParser(new OSMRoadAccessParser(), false, false);
            }
            boolean bl = true;
            for (SpatialRuleParser srp : insertLater) {
                this._addEdgeTagParser(srp, false, bl);
            }
            if (this.dateRangeParser == null) {
                this.dateRangeParser = new DateRangeParser(DateRangeParser.createCalendar());
            }
            for (AbstractFlagEncoder encoder : this.flagEncoderList) {
                if (encoder instanceof BikeCommonFlagEncoder) {
                    if (!this.em.hasEncodedValue(RouteNetwork.key("bike"))) {
                        this._addRelationTagParser(new OSMBikeNetworkTagParser());
                    }
                    if (this.em.hasEncodedValue("get_off_bike")) continue;
                    this._addEdgeTagParser(new OSMGetOffBikeParser(), false, false);
                    continue;
                }
                if (!(encoder instanceof FootFlagEncoder) || this.em.hasEncodedValue(RouteNetwork.key("foot"))) continue;
                this._addRelationTagParser(new OSMFootNetworkTagParser());
            }
            for (AbstractFlagEncoder encoder : this.flagEncoderList) {
                encoder.init(this.dateRangeParser);
                this.em.addEncoder(encoder);
            }
            for (TurnCostParser parser : this.turnCostParsers) {
                this._addTurnCostParser(parser);
            }
            for (AbstractFlagEncoder encoder : this.flagEncoderList) {
                if (!encoder.supportsTurnCosts() || this.em.turnCostParsers.containsKey(encoder.toString())) continue;
                this._addTurnCostParser(new OSMTurnRelationParser(encoder.toString(), encoder.getMaxTurnCosts()));
            }
            if (this.em.encodedValueMap.isEmpty()) {
                throw new IllegalStateException("No EncodedValues found");
            }
            EncodingManager encodingManager = this.em;
            this.em = null;
            return encodingManager;
        }
    }
}

