/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.template;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import java.util.List;

public abstract class AbstractRoutingTemplate {
    protected final EdgeFilter edgeFilter;
    protected final BooleanEncodedValue accessEnc;
    protected final LocationIndex locationIndex;
    protected final EncodedValueLookup lookup;
    protected List<QueryResult> queryResults;

    protected AbstractRoutingTemplate(LocationIndex locationIndex, EncodedValueLookup lookup, final Weighting weighting) {
        this.locationIndex = locationIndex;
        this.lookup = lookup;
        this.accessEnc = weighting.getFlagEncoder().getAccessEnc();
        this.edgeFilter = new EdgeFilter(){

            @Override
            public boolean accept(EdgeIteratorState edgeState) {
                return edgeState.get(AbstractRoutingTemplate.this.accessEnc) && !Double.isInfinite(weighting.calcEdgeWeight(edgeState, false)) || edgeState.getReverse(AbstractRoutingTemplate.this.accessEnc) && !Double.isInfinite(weighting.calcEdgeWeight(edgeState, true));
            }
        };
    }

    protected PointList getWaypoints() {
        PointList pointList = new PointList(this.queryResults.size(), true);
        for (QueryResult qr : this.queryResults) {
            pointList.add((GHPoint)qr.getSnappedPoint());
        }
        return pointList;
    }
}

