/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.CHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;

public class VirtualEdgeIteratorState
implements EdgeIteratorState,
CHEdgeIteratorState {
    private final PointList pointList;
    private final int edgeId;
    private final int baseNode;
    private final int adjNode;
    private final int originalEdgeKey;
    private double distance;
    private IntsRef edgeFlags;
    private String name;
    private boolean unfavored;
    private EdgeIteratorState reverseEdge;
    private final boolean reverse;

    public VirtualEdgeIteratorState(int originalEdgeKey, int edgeId, int baseNode, int adjNode, double distance, IntsRef edgeFlags, String name, PointList pointList, boolean reverse) {
        this.originalEdgeKey = originalEdgeKey;
        this.edgeId = edgeId;
        this.baseNode = baseNode;
        this.adjNode = adjNode;
        this.distance = distance;
        this.edgeFlags = edgeFlags;
        this.name = name;
        this.pointList = pointList;
        this.reverse = reverse;
    }

    public int getOriginalEdgeKey() {
        return this.originalEdgeKey;
    }

    @Override
    public int getEdge() {
        return this.edgeId;
    }

    @Override
    public int getBaseNode() {
        return this.baseNode;
    }

    @Override
    public int getAdjNode() {
        return this.adjNode;
    }

    @Override
    public PointList fetchWayGeometry(FetchMode mode) {
        if (this.pointList.getSize() == 0) {
            return PointList.EMPTY;
        }
        if (mode == FetchMode.TOWER_ONLY) {
            if (this.pointList.getSize() < 3) {
                return this.pointList.clone(false);
            }
            PointList towerNodes = new PointList(2, this.pointList.is3D());
            towerNodes.add((PointAccess)this.pointList, 0);
            towerNodes.add((PointAccess)this.pointList, this.pointList.getSize() - 1);
            return towerNodes;
        }
        if (mode == FetchMode.ALL) {
            return this.pointList.clone(false);
        }
        if (mode == FetchMode.BASE_AND_PILLAR) {
            return this.pointList.copy(0, this.pointList.getSize() - 1);
        }
        if (mode == FetchMode.PILLAR_AND_ADJ) {
            return this.pointList.copy(1, this.pointList.getSize());
        }
        if (mode == FetchMode.PILLAR_ONLY) {
            if (this.pointList.getSize() == 1) {
                return PointList.EMPTY;
            }
            return this.pointList.copy(1, this.pointList.getSize() - 1);
        }
        throw new UnsupportedOperationException("Illegal mode:" + (Object)((Object)mode));
    }

    @Override
    public EdgeIteratorState setWayGeometry(PointList list) {
        throw new UnsupportedOperationException("Not supported for virtual edge. Set when creating it.");
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public EdgeIteratorState setDistance(double dist) {
        this.distance = dist;
        return this;
    }

    @Override
    public IntsRef getFlags() {
        return this.edgeFlags;
    }

    @Override
    public EdgeIteratorState setFlags(IntsRef flags) {
        this.edgeFlags = flags;
        return this;
    }

    @Override
    public boolean get(BooleanEncodedValue property) {
        if (property == EdgeIteratorState.UNFAVORED_EDGE) {
            return this.unfavored;
        }
        return property.getBool(this.reverse, this.edgeFlags);
    }

    @Override
    public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
        property.setBool(this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public boolean getReverse(BooleanEncodedValue property) {
        if (property == EdgeIteratorState.UNFAVORED_EDGE) {
            return this.unfavored;
        }
        return property.getBool(!this.reverse, this.edgeFlags);
    }

    @Override
    public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
        property.setBool(!this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public int get(IntEncodedValue property) {
        return property.getInt(this.reverse, this.edgeFlags);
    }

    @Override
    public EdgeIteratorState set(IntEncodedValue property, int value) {
        property.setInt(this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public int getReverse(IntEncodedValue property) {
        return property.getInt(!this.reverse, this.edgeFlags);
    }

    @Override
    public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
        property.setInt(!this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public double get(DecimalEncodedValue property) {
        return property.getDecimal(this.reverse, this.edgeFlags);
    }

    @Override
    public EdgeIteratorState set(DecimalEncodedValue property, double value) {
        property.setDecimal(this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public double getReverse(DecimalEncodedValue property) {
        return property.getDecimal(!this.reverse, this.edgeFlags);
    }

    @Override
    public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
        property.setDecimal(!this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public <T extends Enum> T get(EnumEncodedValue<T> property) {
        return property.getEnum(this.reverse, this.edgeFlags);
    }

    @Override
    public <T extends Enum> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
        property.setEnum(this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public <T extends Enum> T getReverse(EnumEncodedValue<T> property) {
        return property.getEnum(!this.reverse, this.edgeFlags);
    }

    @Override
    public <T extends Enum> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
        property.setEnum(!this.reverse, this.edgeFlags, value);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EdgeIteratorState setName(String name) {
        this.name = name;
        return this;
    }

    public void setUnfavored(boolean unfavored) {
        this.unfavored = unfavored;
    }

    public String toString() {
        return this.baseNode + "->" + this.adjNode;
    }

    @Override
    public boolean isShortcut() {
        return false;
    }

    @Override
    public boolean getFwdAccess() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean getBwdAccess() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getMergeStatus(int flags) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getSkippedEdge1() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getSkippedEdge2() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public CHEdgeIteratorState setSkippedEdges(int edge1, int edge2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getOrigEdgeFirst() {
        return this.getEdge();
    }

    @Override
    public int getOrigEdgeLast() {
        return this.getEdge();
    }

    @Override
    public EdgeIteratorState detach(boolean reverse) {
        if (reverse) {
            this.reverseEdge.setFlags(this.getFlags());
            this.reverseEdge.setName(this.getName());
            this.reverseEdge.setDistance(this.getDistance());
            return this.reverseEdge;
        }
        return this;
    }

    @Override
    public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState fromEdge) {
        throw new RuntimeException("Not supported.");
    }

    @Override
    public CHEdgeIteratorState setWeight(double weight) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setFlagsAndWeight(int flags, double weight) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double getWeight() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void setReverseEdge(EdgeIteratorState reverseEdge) {
        this.reverseEdge = reverseEdge;
    }
}

