/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.ch.PrepareCHEdgeExplorer;
import com.graphhopper.routing.ch.PrepareCHEdgeIterator;
import com.graphhopper.routing.ch.ShortcutFilter;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;

public class PrepareCHEdgeIteratorImpl
implements PrepareCHEdgeExplorer,
PrepareCHEdgeIterator {
    private final EdgeExplorer edgeExplorer;
    private final Weighting weighting;
    private final ShortcutFilter shortcutFilter;
    private final BooleanEncodedValue accessEnc;
    private EdgeIterator chIterator;

    public static PrepareCHEdgeExplorer inEdges(EdgeExplorer edgeExplorer, Weighting weighting) {
        return new PrepareCHEdgeIteratorImpl(edgeExplorer, weighting, ShortcutFilter.inEdges());
    }

    public static PrepareCHEdgeExplorer outEdges(EdgeExplorer edgeExplorer, Weighting weighting) {
        return new PrepareCHEdgeIteratorImpl(edgeExplorer, weighting, ShortcutFilter.outEdges());
    }

    public static PrepareCHEdgeExplorer allEdges(EdgeExplorer edgeExplorer, Weighting weighting) {
        return new PrepareCHEdgeIteratorImpl(edgeExplorer, weighting, ShortcutFilter.allEdges());
    }

    public PrepareCHEdgeIteratorImpl(EdgeExplorer edgeExplorer, Weighting weighting, ShortcutFilter shortcutFilter) {
        this.edgeExplorer = edgeExplorer;
        this.weighting = weighting;
        this.shortcutFilter = shortcutFilter;
        this.accessEnc = weighting.getFlagEncoder().getAccessEnc();
    }

    @Override
    public PrepareCHEdgeIteratorImpl setBaseNode(int node) {
        this.chIterator = this.edgeExplorer.setBaseNode(node);
        return this;
    }

    @Override
    public boolean next() {
        this.assertBaseNodeSet();
        do {
            boolean hasNext;
            if (hasNext = this.chIterator.next()) continue;
            return false;
        } while (!this.hasAccess());
        return true;
    }

    private boolean hasAccess() {
        if (this.isShortcut()) {
            return this.shortcutFilter.accept((CHEdgeIterator)this.chIterator);
        }
        if (this.chIterator.getBaseNode() == this.chIterator.getAdjNode()) {
            return this.finiteWeight(false) || this.finiteWeight(true);
        }
        return this.shortcutFilter.fwd && this.finiteWeight(false) || this.shortcutFilter.bwd && this.finiteWeight(true);
    }

    private boolean finiteWeight(boolean reverse) {
        return !Double.isInfinite(this.getOrigEdgeWeight(reverse, false));
    }

    private double getOrigEdgeWeight(boolean reverse, boolean needWeight) {
        boolean access;
        boolean bl = access = reverse ? this.chIterator.getReverse(this.accessEnc) : this.chIterator.get(this.accessEnc);
        if (!access) {
            return Double.POSITIVE_INFINITY;
        }
        if (!needWeight) {
            return 0.0;
        }
        return this.weighting.calcEdgeWeight(this.chIterator, reverse);
    }

    @Override
    public int getEdge() {
        this.assertBaseNodeSet();
        return this.chIterator.getEdge();
    }

    @Override
    public int getBaseNode() {
        this.assertBaseNodeSet();
        return this.chIterator.getBaseNode();
    }

    @Override
    public int getAdjNode() {
        this.assertBaseNodeSet();
        return this.chIterator.getAdjNode();
    }

    @Override
    public int getOrigEdgeFirst() {
        this.assertBaseNodeSet();
        return this.chIterator.getOrigEdgeFirst();
    }

    @Override
    public int getOrigEdgeLast() {
        this.assertBaseNodeSet();
        return this.chIterator.getOrigEdgeLast();
    }

    @Override
    public boolean isShortcut() {
        this.assertBaseNodeSet();
        EdgeIterator iter = this.chIterator;
        return iter instanceof CHEdgeIterator && ((CHEdgeIterator)iter).isShortcut();
    }

    @Override
    public double getWeight(boolean reverse) {
        if (this.isShortcut()) {
            return ((CHEdgeIterator)this.chIterator).getWeight();
        }
        this.assertBaseNodeSet();
        return this.getOrigEdgeWeight(reverse, true);
    }

    @Override
    public void setWeight(double weight) {
        this.assertBaseNodeSet();
        ((CHEdgeIterator)this.chIterator).setWeight(weight);
    }

    public String toString() {
        if (this.chIterator == null) {
            return "not initialized";
        }
        return this.getBaseNode() + "->" + this.getAdjNode() + " (" + this.getEdge() + ")";
    }

    @Override
    public int getMergeStatus(int flags) {
        this.assertBaseNodeSet();
        return ((CHEdgeIterator)this.chIterator).getMergeStatus(flags);
    }

    @Override
    public void setFlagsAndWeight(int flags, double weight) {
        this.assertBaseNodeSet();
        ((CHEdgeIterator)this.chIterator).setFlagsAndWeight(flags, weight);
    }

    @Override
    public void setSkippedEdges(int skippedEdge1, int skippedEdge2) {
        this.assertBaseNodeSet();
        ((CHEdgeIterator)this.chIterator).setSkippedEdges(skippedEdge1, skippedEdge2);
    }

    private void assertBaseNodeSet() {
        assert (this.chIterator != null) : "You need to call setBaseNode() before using the iterator";
    }
}

