/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.apache.commons.collections.IntDoubleBinaryHeap;
import com.graphhopper.routing.ch.PrepareCHEdgeExplorer;
import com.graphhopper.routing.ch.PrepareCHEdgeIterator;
import com.graphhopper.routing.ch.PrepareCHGraph;
import java.util.Arrays;

public class NodeBasedWitnessPathSearcher {
    private static final int EMPTY_PARENT = -1;
    private static final int NOT_FOUND = -1;
    private final PrepareCHGraph graph;
    private final PrepareCHEdgeExplorer outEdgeExplorer;
    private final IntArrayList changedNodes;
    private final int maxLevel;
    private int maxVisitedNodes = Integer.MAX_VALUE;
    protected double[] weights;
    private int[] parents;
    private int[] edgeIds;
    private IntDoubleBinaryHeap heap;
    private int ignoreNode = -1;
    private int visitedNodes;
    private boolean doClear = true;
    private int currNode;
    private int to;
    private double weightLimit = Double.MAX_VALUE;

    public NodeBasedWitnessPathSearcher(PrepareCHGraph graph) {
        this(graph, graph.getNodes());
    }

    public NodeBasedWitnessPathSearcher(PrepareCHGraph graph, int maxLevel) {
        this.graph = graph;
        this.maxLevel = maxLevel;
        this.outEdgeExplorer = graph.createOutEdgeExplorer();
        this.parents = new int[graph.getNodes()];
        Arrays.fill(this.parents, -1);
        this.edgeIds = new int[graph.getNodes()];
        Arrays.fill(this.edgeIds, -1);
        this.weights = new double[graph.getNodes()];
        Arrays.fill(this.weights, Double.MAX_VALUE);
        this.heap = new IntDoubleBinaryHeap(1000);
        this.changedNodes = new IntArrayList();
    }

    public NodeBasedWitnessPathSearcher clear() {
        this.doClear = true;
        return this;
    }

    public double getWeight(int endNode) {
        return this.weights[endNode];
    }

    public int findEndNode(int from, int to) {
        if (this.weights.length < 2) {
            return -1;
        }
        this.to = to;
        if (this.doClear) {
            this.doClear = false;
            int vn = this.changedNodes.size();
            for (int i = 0; i < vn; ++i) {
                int n = this.changedNodes.get(i);
                this.weights[n] = Double.MAX_VALUE;
                this.parents[n] = -1;
                this.edgeIds[n] = -1;
            }
            this.heap.clear();
            this.changedNodes.elementsCount = 0;
            this.currNode = from;
            this.weights[this.currNode] = 0.0;
            this.changedNodes.add(this.currNode);
        } else {
            int parentNode = this.parents[to];
            if (parentNode != -1 && this.weights[to] <= this.weights[this.currNode]) {
                return to;
            }
            if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded()) {
                return -1;
            }
            this.currNode = this.heap.poll_element();
        }
        this.visitedNodes = 0;
        if (this.finished()) {
            if (this.heap.isEmpty()) {
                this.doClear = true;
            }
            return this.currNode;
        }
        while (true) {
            ++this.visitedNodes;
            PrepareCHEdgeIterator iter = this.outEdgeExplorer.setBaseNode(this.currNode);
            while (iter.next()) {
                double tmpWeight;
                int adjNode = iter.getAdjNode();
                int prevEdgeId = this.edgeIds[adjNode];
                if (!this.accept(iter, prevEdgeId) || Double.isInfinite(tmpWeight = iter.getWeight(false) + this.weights[this.currNode])) continue;
                double w = this.weights[adjNode];
                if (w == Double.MAX_VALUE) {
                    this.parents[adjNode] = this.currNode;
                    this.weights[adjNode] = tmpWeight;
                    this.heap.insert_(tmpWeight, adjNode);
                    this.changedNodes.add(adjNode);
                    this.edgeIds[adjNode] = iter.getEdge();
                    continue;
                }
                if (!(w > tmpWeight)) continue;
                this.parents[adjNode] = this.currNode;
                this.weights[adjNode] = tmpWeight;
                this.heap.update_(tmpWeight, adjNode);
                this.changedNodes.add(adjNode);
                this.edgeIds[adjNode] = iter.getEdge();
            }
            if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded() || this.isWeightLimitExceeded()) {
                return -1;
            }
            this.currNode = this.heap.peek_element();
            if (this.finished()) {
                return this.currNode;
            }
            this.heap.poll_element();
        }
    }

    public boolean finished() {
        return this.currNode == this.to;
    }

    public void setWeightLimit(double weightLimit) {
        this.weightLimit = weightLimit;
    }

    protected boolean isWeightLimitExceeded() {
        return this.weights[this.currNode] > this.weightLimit;
    }

    public void close() {
        this.weights = null;
        this.parents = null;
        this.edgeIds = null;
        this.heap = null;
    }

    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public String getMemoryUsageAsString() {
        long len = this.weights.length;
        return (16L * len + (long)this.changedNodes.buffer.length * 4L + this.heap.getCapacity() * 8L) / 0x100000L + "MB";
    }

    public void setMaxVisitedNodes(int numberOfNodes) {
        this.maxVisitedNodes = numberOfNodes;
    }

    public void ignoreNode(int node) {
        this.ignoreNode = node;
    }

    private boolean accept(PrepareCHEdgeIterator iter, int prevOrNextEdgeId) {
        if (iter.getEdge() == prevOrNextEdgeId) {
            return false;
        }
        if (this.graph.getLevel(iter.getAdjNode()) != this.maxLevel) {
            return false;
        }
        return this.ignoreNode < 0 || iter.getAdjNode() != this.ignoreNode;
    }

    private boolean isMaxVisitedNodesExceeded() {
        return this.maxVisitedNodes < this.getVisitedNodes();
    }
}

