/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import java.util.Objects;

public class DirectionResolverResult {
    private static DirectionResolverResult UNRESTRICTED = new DirectionResolverResult(-2, -2, -2, -2);
    private static DirectionResolverResult IMPOSSIBLE = new DirectionResolverResult(-1, -1, -1, -1);
    private final int inEdgeRight;
    private final int outEdgeRight;
    private final int inEdgeLeft;
    private final int outEdgeLeft;

    public static DirectionResolverResult onlyLeft(int inEdge, int outEdge) {
        return new DirectionResolverResult(-1, -1, inEdge, outEdge);
    }

    public static DirectionResolverResult onlyRight(int inEdge, int outEdge) {
        return new DirectionResolverResult(inEdge, outEdge, -1, -1);
    }

    public static DirectionResolverResult restricted(int inEdgeRight, int outEdgeRight, int inEdgeLeft, int outEdgeLeft) {
        return new DirectionResolverResult(inEdgeRight, outEdgeRight, inEdgeLeft, outEdgeLeft);
    }

    public static DirectionResolverResult unrestricted() {
        return UNRESTRICTED;
    }

    public static DirectionResolverResult impossible() {
        return IMPOSSIBLE;
    }

    private DirectionResolverResult(int inEdgeRight, int outEdgeRight, int inEdgeLeft, int outEdgeLeft) {
        this.inEdgeRight = inEdgeRight;
        this.outEdgeRight = outEdgeRight;
        this.inEdgeLeft = inEdgeLeft;
        this.outEdgeLeft = outEdgeLeft;
    }

    public static int getOutEdge(DirectionResolverResult directionResolverResult, String curbside) {
        if (curbside.trim().isEmpty()) {
            curbside = "any";
        }
        switch (curbside) {
            case "right": {
                return directionResolverResult.getOutEdgeRight();
            }
            case "left": {
                return directionResolverResult.getOutEdgeLeft();
            }
            case "any": {
                return -2;
            }
        }
        throw new IllegalArgumentException("Unknown value for curbside : '" + curbside + "'. allowed: " + "left" + ", " + "right" + ", " + "any");
    }

    public static int getInEdge(DirectionResolverResult directionResolverResult, String curbside) {
        if (curbside.trim().isEmpty()) {
            curbside = "any";
        }
        switch (curbside) {
            case "right": {
                return directionResolverResult.getInEdgeRight();
            }
            case "left": {
                return directionResolverResult.getInEdgeLeft();
            }
            case "any": {
                return -2;
            }
        }
        throw new IllegalArgumentException("Unknown value for 'curbside : " + curbside + "'. allowed: " + "left" + ", " + "right" + ", " + "any");
    }

    public int getInEdgeRight() {
        return this.inEdgeRight;
    }

    public int getOutEdgeRight() {
        return this.outEdgeRight;
    }

    public int getInEdgeLeft() {
        return this.inEdgeLeft;
    }

    public int getOutEdgeLeft() {
        return this.outEdgeLeft;
    }

    public boolean isRestricted() {
        return !this.equals(UNRESTRICTED);
    }

    public boolean isImpossible() {
        return this.equals(IMPOSSIBLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectionResolverResult that = (DirectionResolverResult)o;
        return this.inEdgeRight == that.inEdgeRight && this.outEdgeRight == that.outEdgeRight && this.inEdgeLeft == that.inEdgeLeft && this.outEdgeLeft == that.outEdgeLeft;
    }

    public int hashCode() {
        return Objects.hash(this.inEdgeRight, this.outEdgeRight, this.inEdgeLeft, this.outEdgeLeft);
    }

    public String toString() {
        if (!this.isRestricted()) {
            return "unrestricted";
        }
        if (this.isImpossible()) {
            return "impossible";
        }
        return "in-edge-right: " + this.pretty(this.inEdgeRight) + ", out-edge-right: " + this.pretty(this.outEdgeRight) + ", in-edge-left: " + this.pretty(this.inEdgeLeft) + ", out-edge-left: " + this.pretty(this.outEdgeLeft);
    }

    private String pretty(int edgeId) {
        if (edgeId == -1) {
            return "NO_EDGE";
        }
        if (edgeId == -2) {
            return "ANY_EDGE";
        }
        return edgeId + "";
    }
}

