/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.graphhopper.routing.DijkstraBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ch.ShortcutUnpacker;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AlternativeRouteEdgeCH
extends DijkstraBidirectionEdgeCHNoSOD {
    private final double maxWeightFactor;
    private final double maxShareFactor;
    private final double localOptimalityFactor;
    private final int maxPaths;
    private int extraVisitedNodes = 0;
    private List<AlternativeInfo> alternatives = new ArrayList<AlternativeInfo>();

    public AlternativeRouteEdgeCH(RoutingCHGraph graph, PMap hints) {
        super(graph);
        this.maxWeightFactor = hints.getDouble("alternative_route.max_weight_factor", 1.25);
        this.maxShareFactor = hints.getDouble("alternative_route.max_share_factor", 0.8);
        this.localOptimalityFactor = hints.getDouble("alternative_route.local_optimality_factor", 0.25);
        this.maxPaths = hints.getInt("alternative_route.max_paths", 3);
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom && this.finishedTo) {
            return true;
        }
        return this.currFrom.weight >= this.bestWeight * this.maxWeightFactor && this.currTo.weight >= this.bestWeight * this.maxWeightFactor;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCountFrom + this.visitedCountTo + this.extraVisitedNodes;
    }

    List<AlternativeInfo> calcAlternatives(int s, int t) {
        this.checkAlreadyRun();
        this.init(s, 0.0, t, 0.0);
        this.runAlgo();
        final Path bestPath = this.extractPath();
        if (!bestPath.isFound()) {
            return Collections.emptyList();
        }
        this.alternatives.add(new AlternativeInfo(bestPath, 0.0));
        final ArrayList potentialAlternativeInfos = new ArrayList();
        final HashMap bestWeightMapByNode = new HashMap();
        this.bestWeightMapTo.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>(){

            public boolean apply(int key, SPTEntry value) {
                bestWeightMapByNode.put(value.adjNode, value);
                return true;
            }
        });
        this.bestWeightMapFrom.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>(){

            public boolean apply(int wurst, SPTEntry fromSPTEntry) {
                SPTEntry toSPTEntry = (SPTEntry)bestWeightMapByNode.get(fromSPTEntry.adjNode);
                if (toSPTEntry == null) {
                    return true;
                }
                if (fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath() > bestPath.getWeight() * AlternativeRouteEdgeCH.this.maxWeightFactor) {
                    return true;
                }
                Path preliminaryRoute = AlternativeRouteEdgeCH.this.createPathExtractor(AlternativeRouteEdgeCH.this.graph).extract(fromSPTEntry, toSPTEntry, fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath());
                double preliminaryShare = AlternativeRouteEdgeCH.this.calculateShare(preliminaryRoute);
                if (preliminaryShare > AlternativeRouteEdgeCH.this.maxShareFactor) {
                    return true;
                }
                PotentialAlternativeInfo potentialAlternativeInfo = new PotentialAlternativeInfo();
                potentialAlternativeInfo.in = AlternativeRouteEdgeCH.this.graph.getEdgeIteratorState(fromSPTEntry.edge, fromSPTEntry.adjNode);
                potentialAlternativeInfo.out = AlternativeRouteEdgeCH.this.graph.getEdgeIteratorState(toSPTEntry.edge, toSPTEntry.adjNode);
                potentialAlternativeInfo.weight = 2.0 * (fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath()) + preliminaryShare;
                potentialAlternativeInfos.add(potentialAlternativeInfo);
                return true;
            }
        });
        Collections.sort(potentialAlternativeInfos, new Comparator<PotentialAlternativeInfo>(){

            @Override
            public int compare(PotentialAlternativeInfo o1, PotentialAlternativeInfo o2) {
                return Double.compare(o1.weight, o2.weight);
            }
        });
        for (PotentialAlternativeInfo potentialAlternativeInfo : potentialAlternativeInfos) {
            IntIndexedContainer svNodes;
            int vIndex;
            double share;
            double directLength;
            final ArrayList ins = new ArrayList();
            new ShortcutUnpacker(this.graph, new ShortcutUnpacker.Visitor(){

                @Override
                public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
                    EdgeIteratorState pups = edge.detach(false);
                    ins.add(pups);
                }
            }, true).visitOriginalEdgesFwd(potentialAlternativeInfo.in.getEdge(), potentialAlternativeInfo.in.getAdjNode(), false, -1);
            final ArrayList outs = new ArrayList();
            new ShortcutUnpacker(this.graph, new ShortcutUnpacker.Visitor(){

                @Override
                public void visit(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
                    EdgeIteratorState pups = edge.detach(true);
                    outs.add(pups);
                }
            }, true).visitOriginalEdgesBwd(potentialAlternativeInfo.out.getEdge(), potentialAlternativeInfo.out.getAdjNode(), true, -1);
            EdgeIteratorState tailSv = (EdgeIteratorState)ins.get(ins.size() - 1);
            EdgeIteratorState headVt = (EdgeIteratorState)outs.get(0);
            int v = tailSv.getAdjNode();
            assert (v == headVt.getBaseNode());
            DijkstraBidirectionEdgeCHNoSOD svRouter = new DijkstraBidirectionEdgeCHNoSOD(this.graph);
            Path svPath = svRouter.calcPath(s, v, -2, tailSv.getEdge());
            this.extraVisitedNodes += svRouter.getVisitedNodes();
            DijkstraBidirectionEdgeCHNoSOD vtRouter = new DijkstraBidirectionEdgeCHNoSOD(this.graph);
            Path vtPath = vtRouter.calcPath(v, t, headVt.getEdge(), -2);
            Path path = AlternativeRouteEdgeCH.concat(this.graph.getGraph().getBaseGraph(), svPath, vtPath);
            this.extraVisitedNodes += vtRouter.getVisitedNodes();
            double sharedDistanceWithShortest = this.sharedDistanceWithShortest(path);
            double detourLength = path.getDistance() - sharedDistanceWithShortest;
            if (detourLength > (directLength = bestPath.getDistance() - sharedDistanceWithShortest) * this.maxWeightFactor || (share = this.calculateShare(path)) > this.maxShareFactor || !this.tTest(path, vIndex = (svNodes = svPath.calcNodes()).size() - 1)) continue;
            this.alternatives.add(new AlternativeInfo(path, share));
            if (this.alternatives.size() < this.maxPaths) continue;
            break;
        }
        return this.alternatives;
    }

    private double calculateShare(Path path) {
        double sharedDistance = this.sharedDistance(path);
        return sharedDistance / path.getDistance();
    }

    private double sharedDistance(Path path) {
        double sharedDistance = 0.0;
        List<EdgeIteratorState> edges = path.calcEdges();
        for (EdgeIteratorState edge : edges) {
            if (!this.nodesInCurrentAlternativeSetContains(edge.getBaseNode()) || !this.nodesInCurrentAlternativeSetContains(edge.getAdjNode())) continue;
            sharedDistance += edge.getDistance();
        }
        return sharedDistance;
    }

    private double sharedDistanceWithShortest(Path path) {
        double sharedDistance = 0.0;
        List<EdgeIteratorState> edges = path.calcEdges();
        for (EdgeIteratorState edge : edges) {
            if (!this.alternatives.get((int)0).nodes.contains(edge.getBaseNode()) || !this.alternatives.get((int)0).nodes.contains(edge.getAdjNode())) continue;
            sharedDistance += edge.getDistance();
        }
        return sharedDistance;
    }

    private boolean nodesInCurrentAlternativeSetContains(int v) {
        for (AlternativeInfo alternative : this.alternatives) {
            if (!alternative.nodes.contains(v)) continue;
            return true;
        }
        return false;
    }

    private boolean tTest(Path path, int vIndex) {
        if (path.getEdgeCount() == 0) {
            return true;
        }
        double detourDistance = this.detourDistance(path);
        double T = 0.5 * this.localOptimalityFactor * detourDistance;
        EdgeIteratorState fromNode = this.getPreviousNodeTMetersAway(path, vIndex, T);
        EdgeIteratorState toNode = this.getNextNodeTMetersAway(path, vIndex, T);
        DijkstraBidirectionEdgeCHNoSOD tRouter = new DijkstraBidirectionEdgeCHNoSOD(this.graph);
        Path tPath = tRouter.calcPath(fromNode.getBaseNode(), toNode.getAdjNode(), fromNode.getEdge(), toNode.getEdge());
        this.extraVisitedNodes += tRouter.getVisitedNodes();
        IntIndexedContainer tNodes = tPath.calcNodes();
        int v = path.calcNodes().get(vIndex);
        return tNodes.contains(v);
    }

    private double detourDistance(Path path) {
        return path.getDistance() - this.sharedDistanceWithShortest(path);
    }

    private EdgeIteratorState getPreviousNodeTMetersAway(Path path, int vIndex, double T) {
        int i;
        List<EdgeIteratorState> edges = path.calcEdges();
        double distance = 0.0;
        for (i = vIndex; i > 0 && distance < T; distance += edges.get(i - 1).getDistance(), --i) {
        }
        return edges.get(i);
    }

    private EdgeIteratorState getNextNodeTMetersAway(Path path, int vIndex, double T) {
        int i;
        List<EdgeIteratorState> edges = path.calcEdges();
        double distance = 0.0;
        for (i = vIndex; i < edges.size() - 1 && distance < T; distance += edges.get(i).getDistance(), ++i) {
        }
        return edges.get(i - 1);
    }

    private static Path concat(Graph graph, Path svPath, Path vtPath) {
        assert (svPath.isFound());
        assert (vtPath.isFound());
        Path path = new Path(graph);
        path.setFromNode(svPath.calcNodes().get(0));
        for (EdgeIteratorState edge : svPath.calcEdges()) {
            path.addEdge(edge.getEdge());
        }
        for (EdgeIteratorState edge : vtPath.calcEdges()) {
            path.addEdge(edge.getEdge());
        }
        path.setEndNode(vtPath.getEndNode());
        path.setWeight(svPath.getWeight() + vtPath.getWeight());
        path.setDistance(svPath.getDistance() + vtPath.getDistance());
        path.addTime(svPath.time + vtPath.time);
        path.setFound(true);
        return path;
    }

    @Override
    public List<Path> calcPaths(int from, int to) {
        List<AlternativeInfo> alts = this.calcAlternatives(from, to);
        if (alts.isEmpty()) {
            return Collections.singletonList(this.createEmptyPath());
        }
        ArrayList<Path> paths = new ArrayList<Path>(alts.size());
        for (AlternativeInfo a : alts) {
            paths.add(a.path);
        }
        return paths;
    }

    public static class AlternativeInfo {
        final double shareWeight;
        final Path path;
        final IntIndexedContainer nodes;

        AlternativeInfo(Path path, double shareWeight) {
            this.path = path;
            this.shareWeight = shareWeight;
            this.nodes = path.calcNodes();
        }

        public String toString() {
            return "AlternativeInfo{shareWeight=" + this.shareWeight + ", path=" + this.path.calcNodes() + '}';
        }

        public Path getPath() {
            return this.path;
        }
    }

    public static class PotentialAlternativeInfo {
        public RoutingCHEdgeIteratorState in;
        public RoutingCHEdgeIteratorState out;
        double weight;
    }
}

