/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.BidirPathExtractor;
import com.graphhopper.routing.BidirRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.PriorityQueue;

public abstract class AbstractNonCHBidirAlgo
extends AbstractBidirAlgo
implements BidirRoutingAlgorithm {
    protected final Graph graph;
    protected final Weighting weighting;
    protected final FlagEncoder flagEncoder;
    protected EdgeExplorer edgeExplorer;
    protected EdgeFilter inEdgeFilter;
    protected EdgeFilter outEdgeFilter;
    protected EdgeFilter additionalEdgeFilter;

    public AbstractNonCHBidirAlgo(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(tMode);
        this.weighting = weighting;
        if (weighting.hasTurnCosts() && !tMode.isEdgeBased()) {
            throw new IllegalStateException("Weightings supporting turn costs cannot be used with node-based traversal mode");
        }
        this.flagEncoder = weighting.getFlagEncoder();
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.edgeExplorer = graph.createEdgeExplorer();
        this.outEdgeFilter = DefaultEdgeFilter.outEdges(this.flagEncoder.getAccessEnc());
        this.inEdgeFilter = DefaultEdgeFilter.inEdges(this.flagEncoder.getAccessEnc());
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 150000);
        this.initCollections(size);
    }

    protected abstract SPTEntry createEntry(EdgeIteratorState var1, int var2, double var3, SPTEntry var5, boolean var6);

    protected BidirPathExtractor createPathExtractor(Graph graph, Weighting weighting) {
        return new BidirPathExtractor(graph, weighting);
    }

    @Override
    protected void postInitFrom() {
        if (this.fromOutEdge == -2) {
            this.fillEdgesFrom();
        } else {
            this.fillEdgesFromUsingFilter(new EdgeFilter(){

                @Override
                public boolean accept(EdgeIteratorState edgeState) {
                    return edgeState.getOrigEdgeFirst() == AbstractNonCHBidirAlgo.this.fromOutEdge;
                }
            });
        }
    }

    @Override
    protected void postInitTo() {
        if (this.toInEdge == -2) {
            this.fillEdgesTo();
        } else {
            this.fillEdgesToUsingFilter(new EdgeFilter(){

                @Override
                public boolean accept(EdgeIteratorState edgeState) {
                    return edgeState.getOrigEdgeLast() == AbstractNonCHBidirAlgo.this.toInEdge;
                }
            });
        }
    }

    protected void fillEdgesFromUsingFilter(EdgeFilter edgeFilter) {
        this.additionalEdgeFilter = edgeFilter;
        this.finishedFrom = !this.fillEdgesFrom();
        this.additionalEdgeFilter = null;
    }

    protected void fillEdgesToUsingFilter(EdgeFilter edgeFilter) {
        this.additionalEdgeFilter = edgeFilter;
        this.finishedTo = !this.fillEdgesTo();
        this.additionalEdgeFilter = null;
    }

    @Override
    boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = (SPTEntry)this.pqOpenSetFrom.poll();
        ++this.visitedCountFrom;
        if (this.fromEntryCanBeSkipped()) {
            return true;
        }
        if (this.fwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, (IntObjectMap<SPTEntry>)this.bestWeightMapFrom, false);
        return true;
    }

    @Override
    boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = (SPTEntry)this.pqOpenSetTo.poll();
        ++this.visitedCountTo;
        if (this.toEntryCanBeSkipped()) {
            return true;
        }
        if (this.bwdSearchCanBeStopped()) {
            return false;
        }
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, (IntObjectMap<SPTEntry>)this.bestWeightMapTo, true);
        return true;
    }

    private void fillEdges(SPTEntry currEdge, PriorityQueue<SPTEntry> prioQueue, IntObjectMap<SPTEntry> bestWeightMap, boolean reverse) {
        EdgeIterator iter = this.edgeExplorer.setBaseNode(currEdge.adjNode);
        while (iter.next()) {
            double weight;
            if (!this.accept(iter, currEdge, reverse) || Double.isInfinite(weight = this.calcWeight(iter, currEdge, reverse))) continue;
            int origEdgeId = this.getOrigEdgeId(iter, reverse);
            int traversalId = this.getTraversalId(iter, origEdgeId, reverse);
            SPTEntry entry = (SPTEntry)bestWeightMap.get(traversalId);
            if (entry == null) {
                entry = this.createEntry(iter, origEdgeId, weight, currEdge, reverse);
                bestWeightMap.put(traversalId, (Object)entry);
                prioQueue.add(entry);
            } else {
                if (!(entry.getWeightOfVisitedPath() > weight)) continue;
                prioQueue.remove(entry);
                this.updateEntry(entry, iter, origEdgeId, weight, currEdge, reverse);
                prioQueue.add(entry);
            }
            if (!this.updateBestPath) continue;
            double edgeWeight = this.traversalMode.isEdgeBased() ? this.weighting.calcEdgeWeight(iter, reverse) : Double.POSITIVE_INFINITY;
            this.updateBestPath(edgeWeight, entry, origEdgeId, traversalId, reverse);
        }
    }

    protected void updateEntry(SPTEntry entry, EdgeIteratorState edge, int edgeId, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge.getEdge();
        entry.weight = weight;
        entry.parent = parent;
    }

    protected boolean accept(EdgeIteratorState edge, SPTEntry currEdge, boolean reverse) {
        return this.accept(edge, this.getIncomingEdge(currEdge));
    }

    protected int getOrigEdgeId(EdgeIteratorState edge, boolean reverse) {
        return edge.getEdge();
    }

    protected int getTraversalId(EdgeIteratorState edge, int origEdgeId, boolean reverse) {
        return this.traversalMode.createTraversalId(edge, reverse);
    }

    protected double calcWeight(EdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        boolean access;
        boolean bl = access = reverse ? this.inEdgeFilter.accept(iter) : this.outEdgeFilter.accept(iter);
        if (!access) {
            return Double.POSITIVE_INFINITY;
        }
        return GHUtility.calcWeightWithTurnWeight(this.weighting, iter, reverse, this.getIncomingEdge(currEdge)) + currEdge.getWeightOfVisitedPath();
    }

    @Override
    protected double getInEdgeWeight(SPTEntry entry) {
        return this.weighting.calcEdgeWeight(this.graph.getEdgeIteratorState(this.getIncomingEdge(entry), entry.adjNode), false);
    }

    @Override
    protected int getOtherNode(int edge, int node) {
        return this.graph.getOtherNode(edge, node);
    }

    @Override
    protected Path extractPath() {
        if (this.finished()) {
            return this.createPathExtractor(this.graph, this.weighting).extract(this.bestFwdEntry, this.bestBwdEntry, this.bestWeight);
        }
        return this.createEmptyPath();
    }

    protected boolean accept(EdgeIteratorState iter, int prevOrNextEdgeId) {
        if (!this.traversalMode.isEdgeBased() && iter.getEdge() == prevOrNextEdgeId) {
            return false;
        }
        return this.additionalEdgeFilter == null || this.additionalEdgeFilter.accept(iter);
    }

    protected Path createEmptyPath() {
        return new Path(this.graph);
    }

    public String toString() {
        return this.getName() + "|" + this.weighting;
    }
}

