/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.AbstractNonCHBidirAlgo;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BalancedWeightApproximator;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;

public class AStarBidirection
extends AbstractNonCHBidirAlgo {
    private BalancedWeightApproximator weightApprox;
    double stoppingCriterionOffset;

    public AStarBidirection(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, weighting);
        defaultApprox.setDistanceCalc((DistanceCalc)Helper.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    @Override
    void init(int from, double fromWeight, int to, double toWeight) {
        this.weightApprox.setFromTo(from, to);
        this.stoppingCriterionOffset = this.weightApprox.approximate(to, true) + this.weightApprox.getSlack();
        super.init(from, fromWeight, to, toWeight);
    }

    @Override
    protected boolean finished() {
        if (this.finishedFrom || this.finishedTo) {
            return true;
        }
        return this.currFrom.weight + this.currTo.weight >= this.bestWeight + this.stoppingCriterionOffset;
    }

    @Override
    protected SPTEntry createStartEntry(int node, double weight, boolean reverse) {
        double heapWeight = weight + this.weightApprox.approximate(node, reverse);
        return new AStar.AStarEntry(-1, node, heapWeight, weight);
    }

    @Override
    protected SPTEntry createEntry(EdgeIteratorState edge, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        int neighborNode = edge.getAdjNode();
        double heapWeight = weight + this.weightApprox.approximate(neighborNode, reverse);
        AStar.AStarEntry entry = new AStar.AStarEntry(edge.getEdge(), neighborNode, heapWeight, weight);
        entry.parent = parent;
        return entry;
    }

    @Override
    protected void updateEntry(SPTEntry entry, EdgeIteratorState edge, int edgeId, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge.getEdge();
        entry.weight = weight + this.weightApprox.approximate(edge.getAdjNode(), reverse);
        ((AStar.AStarEntry)entry).weightOfVisitedPath = weight;
        entry.parent = parent;
    }

    @Override
    protected double calcWeight(EdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        return super.calcWeight(iter, currEdge, reverse);
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    public AStarBidirection setApproximation(WeightApproximator approx) {
        this.weightApprox = new BalancedWeightApproximator(approx);
        return this;
    }

    @Override
    void setToDataStructures(AbstractBidirAlgo other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "astarbi|" + this.weightApprox;
    }
}

