/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperAPI;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.reader.DataReader;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.SkadiProvider;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ch.CHPreparationHandler;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ev.DefaultEncodedValueFactory;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMPreparationHandler;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.template.AbstractRoutingTemplate;
import com.graphhopper.routing.template.AlternativeRoutingTemplate;
import com.graphhopper.routing.template.RoundTripRoutingTemplate;
import com.graphhopper.routing.template.RoutingTemplate;
import com.graphhopper.routing.template.ViaRoutingTemplate;
import com.graphhopper.routing.util.CustomModel;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.DefaultFlagEncoderFactory;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.util.parsers.DefaultTagParserFactory;
import com.graphhopper.routing.util.parsers.TagParserFactory;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.ShortFastestWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointDistanceExceededException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper
implements GraphHopperAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
    private final String fileLockName = "gh.lock";
    private final TranslationMap trMap = new TranslationMap().doImport();
    boolean removeZipped = true;
    private GraphHopperStorage ghStorage;
    private EncodingManager encodingManager;
    private int defaultSegmentSize = -1;
    private String ghLocation = "";
    private DAType dataAccessType = DAType.RAM_STORE;
    private boolean sortGraph = false;
    private boolean elevation = false;
    private LockFactory lockFactory = new NativeFSLockFactory();
    private boolean allowWrites = true;
    private boolean fullyLoaded = false;
    private boolean smoothElevation = false;
    private final RoutingConfig routingConfig = new RoutingConfig();
    private LocationIndex locationIndex;
    private int preciseIndexResolution = 300;
    private int maxRegionSearch = 4;
    private int minNetworkSize = 200;
    private final LMPreparationHandler lmPreparationHandler = new LMPreparationHandler();
    private final CHPreparationHandler chPreparationHandler = new CHPreparationHandler();
    private String dataReaderFile;
    private double dataReaderWayPointMaxDistance = 1.0;
    private int dataReaderWorkerThreads = 2;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private FlagEncoderFactory flagEncoderFactory = new DefaultFlagEncoderFactory();
    private EncodedValueFactory encodedValueFactory = new DefaultEncodedValueFactory();
    private TagParserFactory tagParserFactory = new DefaultTagParserFactory();
    private PathDetailsBuilderFactory pathBuilderFactory = new PathDetailsBuilderFactory();
    private static final String INTERPOLATION_KEY = "prepare.elevation_interpolation.done";

    protected GraphHopper loadGraph(GraphHopperStorage g) {
        this.ghStorage = g;
        this.setFullyLoaded();
        this.initLocationIndex();
        return this;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public GraphHopper setEncodingManager(EncodingManager em) {
        this.ensureNotLoaded();
        this.encodingManager = em;
        return this;
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public GraphHopper setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null || eleProvider == ElevationProvider.NOOP) {
            this.setElevation(false);
        } else {
            this.setElevation(true);
        }
        this.eleProvider = eleProvider;
        return this;
    }

    protected int getWorkerThreads() {
        return this.dataReaderWorkerThreads;
    }

    protected double getWayPointMaxDistance() {
        return this.dataReaderWayPointMaxDistance;
    }

    public GraphHopper setWayPointMaxDistance(double wayPointMaxDistance) {
        this.dataReaderWayPointMaxDistance = wayPointMaxDistance;
        return this;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathBuilderFactory) {
        this.pathBuilderFactory = pathBuilderFactory;
        return this;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public GraphHopper forServer() {
        this.setSimplifyResponse(true);
        return this.setInMemory();
    }

    public GraphHopper forDesktop() {
        this.setSimplifyResponse(false);
        return this.setInMemory();
    }

    public GraphHopper forMobile() {
        this.setSimplifyResponse(false);
        return this.setMemoryMapped();
    }

    public GraphHopper setPreciseIndexResolution(int precision) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = precision;
        return this;
    }

    public GraphHopper setMinNetworkSize(int minNetworkSize) {
        this.ensureNotLoaded();
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public GraphHopper setInMemory() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.RAM_STORE;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean storeOnFlush) {
        this.ensureNotLoaded();
        this.dataAccessType = storeOnFlush ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setMemoryMapped() {
        this.ensureNotLoaded();
        this.dataAccessType = DAType.MMAP;
        return this;
    }

    public GraphHopper setProfiles(Profile ... profiles) {
        return this.setProfiles(Arrays.asList(profiles));
    }

    public GraphHopper setProfiles(List<Profile> profiles) {
        this.profilesByName.clear();
        for (Profile profile : profiles) {
            Profile previous = this.profilesByName.put(profile.getName(), profile);
            if (previous == null) continue;
            throw new IllegalArgumentException("Profile names must be unique. Duplicate name: '" + profile.getName() + "'");
        }
        return this;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public Profile getProfile(String profileName) {
        return this.profilesByName.get(profileName);
    }

    public int getMaxVisitedNodes() {
        return this.routingConfig.getMaxVisitedNodes();
    }

    public void setMaxVisitedNodes(int maxVisitedNodes) {
        this.routingConfig.setMaxVisitedNodes(maxVisitedNodes);
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopper setElevation(boolean includeElevation) {
        this.elevation = includeElevation;
        return this;
    }

    public GraphHopper setEnableCalcPoints(boolean b) {
        this.routingConfig.setCalcPoints(b);
        return this;
    }

    private GraphHopper setSimplifyResponse(boolean doSimplify) {
        this.routingConfig.setSimplifyResponse(doSimplify);
        return this;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopper setGraphHopperLocation(String ghLocation) {
        this.ensureNotLoaded();
        if (ghLocation == null) {
            throw new IllegalArgumentException("graphhopper location cannot be null");
        }
        this.ghLocation = ghLocation;
        return this;
    }

    public String getDataReaderFile() {
        return this.dataReaderFile;
    }

    public GraphHopper setDataReaderFile(String dataReaderFileStr) {
        this.ensureNotLoaded();
        if (Helper.isEmpty((String)dataReaderFileStr)) {
            throw new IllegalArgumentException("Data reader file cannot be empty.");
        }
        this.dataReaderFile = dataReaderFileStr;
        return this;
    }

    public GraphHopperStorage getGraphHopperStorage() {
        if (this.ghStorage == null) {
            throw new IllegalStateException("GraphHopper storage not initialized");
        }
        return this.ghStorage;
    }

    public void setGraphHopperStorage(GraphHopperStorage ghStorage) {
        this.ghStorage = ghStorage;
        this.setFullyLoaded();
    }

    public LocationIndex getLocationIndex() {
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        return this.locationIndex;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public GraphHopper setSortGraph(boolean sortGraph) {
        this.ensureNotLoaded();
        this.sortGraph = sortGraph;
        return this;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public GraphHopper setAllowWrites(boolean allowWrites) {
        this.allowWrites = allowWrites;
        return this;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public GraphHopper setFlagEncoderFactory(FlagEncoderFactory factory) {
        this.flagEncoderFactory = factory;
        return this;
    }

    public EncodedValueFactory getEncodedValueFactory() {
        return this.encodedValueFactory;
    }

    public GraphHopper setEncodedValueFactory(EncodedValueFactory factory) {
        this.encodedValueFactory = factory;
        return this;
    }

    public TagParserFactory getTagParserFactory() {
        return this.tagParserFactory;
    }

    public GraphHopper setTagParserFactory(TagParserFactory factory) {
        this.tagParserFactory = factory;
        return this;
    }

    public GraphHopper init(GraphHopperConfig ghConfig) {
        String graphHopperFolder;
        if (ghConfig.has("osmreader.osm")) {
            throw new IllegalArgumentException("Instead osmreader.osm use datareader.file, for other changes see core/files/changelog.txt");
        }
        String tmpOsmFile = ghConfig.getString("datareader.file", "");
        if (!Helper.isEmpty((String)tmpOsmFile)) {
            this.dataReaderFile = tmpOsmFile;
        }
        if (Helper.isEmpty((String)(graphHopperFolder = ghConfig.getString("graph.location", ""))) && Helper.isEmpty((String)this.ghLocation)) {
            if (Helper.isEmpty((String)this.dataReaderFile)) {
                throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
            }
            graphHopperFolder = Helper.pruneFileEnd((String)this.dataReaderFile) + "-gh";
        }
        this.setGraphHopperLocation(graphHopperFolder);
        this.defaultSegmentSize = ghConfig.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
        String graphDATypeStr = ghConfig.getString("graph.dataaccess", "RAM_STORE");
        this.dataAccessType = DAType.fromString(graphDATypeStr);
        this.sortGraph = ghConfig.getBool("graph.do_sort", this.sortGraph);
        this.removeZipped = ghConfig.getBool("graph.remove_zipped", this.removeZipped);
        EncodingManager encodingManager = this.createEncodingManager(ghConfig);
        if (encodingManager != null) {
            this.setEncodingManager(encodingManager);
        }
        this.lockFactory = ghConfig.getString("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
        this.smoothElevation = ghConfig.getBool("graph.elevation.smoothing", false);
        ElevationProvider elevationProvider = GraphHopper.createElevationProvider(ghConfig);
        this.setElevationProvider(elevationProvider);
        this.minNetworkSize = ghConfig.getInt("prepare.min_network_size", this.minNetworkSize);
        this.setProfiles(ghConfig.getProfiles());
        this.chPreparationHandler.init(ghConfig);
        this.lmPreparationHandler.init(ghConfig);
        this.dataReaderWayPointMaxDistance = ghConfig.getDouble("routing.way_point_max_distance", this.dataReaderWayPointMaxDistance);
        this.dataReaderWorkerThreads = ghConfig.getInt("datareader.worker_threads", this.dataReaderWorkerThreads);
        this.preciseIndexResolution = ghConfig.getInt("index.high_resolution", this.preciseIndexResolution);
        this.maxRegionSearch = ghConfig.getInt("index.max_region_search", this.maxRegionSearch);
        this.routingConfig.setMaxVisitedNodes(ghConfig.getInt("routing.max_visited_nodes", this.routingConfig.getMaxVisitedNodes()));
        this.routingConfig.setMaxRoundTripRetries(ghConfig.getInt("routing.round_trip.max_retries", this.routingConfig.getMaxRoundTripRetries()));
        this.routingConfig.setNonChMaxWaypointDistance(ghConfig.getInt("routing.non_ch.max_waypoint_distance", this.routingConfig.getNonChMaxWaypointDistance()));
        return this;
    }

    private EncodingManager createEncodingManager(GraphHopperConfig ghConfig) {
        String flagEncodersStr = ghConfig.getString("graph.flag_encoders", "");
        String encodedValueStr = ghConfig.getString("graph.encoded_values", "");
        if (flagEncodersStr.isEmpty() && encodedValueStr.isEmpty()) {
            return null;
        }
        EncodingManager.Builder emBuilder = new EncodingManager.Builder();
        if (!encodedValueStr.isEmpty()) {
            emBuilder.addAll(this.tagParserFactory, encodedValueStr);
        }
        this.registerCustomEncodedValues(emBuilder);
        if (!flagEncodersStr.isEmpty()) {
            emBuilder.addAll(this.flagEncoderFactory, flagEncodersStr);
        }
        emBuilder.setEnableInstructions(ghConfig.getBool("datareader.instructions", true));
        emBuilder.setPreferredLanguage(ghConfig.getString("datareader.preferred_language", ""));
        emBuilder.setDateRangeParser(DateRangeParser.createInstance(ghConfig.getString("datareader.date_range_parser_day", "")));
        return emBuilder.build();
    }

    private static ElevationProvider createElevationProvider(GraphHopperConfig ghConfig) {
        String baseURL;
        String eleProviderStr = Helper.toLowerCase((String)ghConfig.getString("graph.elevation.provider", "noop"));
        if (ghConfig.has("graph.elevation.calcmean")) {
            throw new IllegalArgumentException("graph.elevation.calcmean is deprecated, use graph.elevation.interpolate");
        }
        boolean interpolate = ghConfig.has("graph.elevation.interpolate") ? "bilinear".equals(ghConfig.getString("graph.elevation.interpolate", "none")) : ghConfig.getBool("graph.elevation.calc_mean", false);
        String cacheDirStr = ghConfig.getString("graph.elevation.cache_dir", "");
        if (cacheDirStr.isEmpty()) {
            cacheDirStr = ghConfig.getString("graph.elevation.cachedir", "");
        }
        if ((baseURL = ghConfig.getString("graph.elevation.base_url", "")).isEmpty()) {
            ghConfig.getString("graph.elevation.baseurl", "");
        }
        boolean removeTempElevationFiles = ghConfig.getBool("graph.elevation.cgiar.clear", true);
        removeTempElevationFiles = ghConfig.getBool("graph.elevation.clear", removeTempElevationFiles);
        DAType elevationDAType = DAType.fromString(ghConfig.getString("graph.elevation.dataaccess", "MMAP"));
        ElevationProvider elevationProvider = ElevationProvider.NOOP;
        if (eleProviderStr.equalsIgnoreCase("srtm")) {
            elevationProvider = new SRTMProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("cgiar")) {
            elevationProvider = new CGIARProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("gmted")) {
            elevationProvider = new GMTEDProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtmgl1")) {
            elevationProvider = new SRTMGL1Provider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("multi")) {
            elevationProvider = new MultiSourceElevationProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("skadi")) {
            elevationProvider = new SkadiProvider(cacheDirStr);
        }
        elevationProvider.setAutoRemoveTemporaryFiles(removeTempElevationFiles);
        elevationProvider.setInterpolate(interpolate);
        if (!baseURL.isEmpty()) {
            elevationProvider.setBaseURL(baseURL);
        }
        elevationProvider.setDAType(elevationDAType);
        return elevationProvider;
    }

    private void printInfo() {
        this.logger.info("version " + Constants.VERSION + "|" + Constants.BUILD_DATE + " (" + Constants.getVersions() + ")");
        if (this.ghStorage != null) {
            this.logger.info("graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString());
        }
    }

    public GraphHopper importOrLoad() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation, false);
        } else {
            this.printInfo();
        }
        return this;
    }

    public void importAndClose() {
        if (!this.load(this.ghLocation)) {
            this.printInfo();
            this.process(this.ghLocation, true);
        } else {
            this.printInfo();
            this.logger.info("Graph already imported into " + this.ghLocation);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphHopper process(String graphHopperLocation, boolean closeEarly) {
        this.setGraphHopperLocation(graphHopperLocation);
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring()) {
                this.lockFactory.setLockDir(new File(graphHopperLocation));
                lock = this.lockFactory.create("gh.lock", true);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid multiple writers we need to obtain a write lock but it failed. In " + graphHopperLocation, lock.getObtainFailedReason());
                }
            }
            this.readData();
            this.cleanUp();
            this.postProcessing(closeEarly);
            this.flush();
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return this;
    }

    private void readData() {
        try {
            DataReader reader = this.importData();
            DateFormat f = Helper.createFormatter();
            this.ghStorage.getProperties().put("datareader.import.date", f.format(new Date()));
            if (reader.getDataDate() != null) {
                this.ghStorage.getProperties().put("datareader.data.date", f.format(reader.getDataDate()));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file " + this.getDataReaderFile(), ex);
        }
    }

    protected DataReader importData() throws IOException {
        this.ensureWriteAccess();
        if (this.ghStorage == null) {
            throw new IllegalStateException("Load graph before importing OSM data");
        }
        if (this.dataReaderFile == null) {
            throw new IllegalStateException("Couldn't load from existing folder: " + this.ghLocation + " but also cannot use file for DataReader as it wasn't specified!");
        }
        DataReader reader = this.createReader(this.ghStorage);
        this.logger.info("using " + this.ghStorage.toString() + ", memory:" + Helper.getMemInfo());
        reader.readGraph();
        return reader;
    }

    protected DataReader createReader(GraphHopperStorage ghStorage) {
        throw new UnsupportedOperationException("Cannot create DataReader. Solutions: avoid import via calling load directly, provide a DataReader or use e.g. GraphHopperOSM or a different subclass");
    }

    protected DataReader initDataReader(DataReader reader) {
        if (this.dataReaderFile == null) {
            throw new IllegalArgumentException("No file for DataReader specified");
        }
        this.logger.info("start creating graph from " + this.dataReaderFile);
        return reader.setFile(new File(this.dataReaderFile)).setElevationProvider(this.eleProvider).setWorkerThreads(this.dataReaderWorkerThreads).setWayPointMaxDistance(this.dataReaderWayPointMaxDistance).setSmoothElevation(this.smoothElevation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String graphHopperFolder) {
        List<CHConfig> chConfigs;
        if (Helper.isEmpty((String)graphHopperFolder)) {
            throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
        }
        if (this.fullyLoaded) {
            throw new IllegalStateException("graph is already successfully loaded");
        }
        File tmpFileOrFolder = new File(graphHopperFolder);
        if (!tmpFileOrFolder.isDirectory() && tmpFileOrFolder.exists()) {
            throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
        }
        File compressed = new File(graphHopperFolder + ".ghz");
        if (compressed.exists() && !compressed.isDirectory()) {
            try {
                new Unzipper().unzip(compressed.getAbsolutePath(), graphHopperFolder, this.removeZipped);
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't extract file " + compressed.getAbsolutePath() + " to " + graphHopperFolder, ex);
            }
        }
        this.setGraphHopperLocation(graphHopperFolder);
        if (this.encodingManager == null) {
            this.setEncodingManager(EncodingManager.create(this.encodedValueFactory, this.flagEncoderFactory, this.ghLocation));
        }
        if (!this.allowWrites && this.dataAccessType.isMMap()) {
            this.dataAccessType = DAType.MMAP_RO;
        }
        GHDirectory dir = new GHDirectory(this.ghLocation, this.dataAccessType);
        this.ghStorage = new GraphHopperStorage(dir, this.encodingManager, this.hasElevation(), this.encodingManager.needsTurnCostsSupport(), this.defaultSegmentSize);
        this.checkProfilesConsistency();
        if (this.lmPreparationHandler.isEnabled()) {
            this.initLMPreparationHandler();
        }
        if (this.chPreparationHandler.isEnabled()) {
            this.initCHPreparationHandler();
            chConfigs = this.chPreparationHandler.getCHConfigs();
        } else {
            chConfigs = Collections.emptyList();
        }
        this.ghStorage.addCHGraphs(chConfigs);
        if (!new File(graphHopperFolder).exists()) {
            return false;
        }
        GHLock lock = null;
        try {
            if (this.ghStorage.getDirectory().getDefaultType().isStoring() && this.isAllowWrites()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", false);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid reading partial data we need to obtain the read lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            if (!this.ghStorage.loadExisting()) {
                boolean bl = false;
                return bl;
            }
            this.postProcessing(false);
            this.setFullyLoaded();
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    private void checkProfilesConsistency() {
        for (Profile profile : this.profilesByName.values()) {
            if (!this.encodingManager.hasEncoder(profile.getVehicle())) {
                throw new IllegalArgumentException("Unknown vehicle '" + profile.getVehicle() + "' in profile: " + profile + ". Make sure all vehicles used in 'profiles' exist in 'graph.flag_encoders'");
            }
            FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
            if (profile.isTurnCosts() && !encoder.supportsTurnCosts()) {
                throw new IllegalArgumentException("The profile '" + profile.getName() + "' was configured with 'turn_costs=true', but the corresponding vehicle '" + profile.getVehicle() + "' does not support turn costs.\nYou need to add `|turn_costs=true` to the vehicle in `graph.flag_encoders`");
            }
            try {
                this.createWeighting(profile, new PMap());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not create weighting for profile: '" + profile.getName() + "'.\nProfile: " + profile + "\nError: " + e.getMessage());
            }
            if (!(profile instanceof CustomProfile)) continue;
            CustomModel customModel = ((CustomProfile)profile).getCustomModel();
            if (customModel == null) {
                throw new IllegalArgumentException("custom model for profile '" + profile.getName() + "' was empty");
            }
            if ("custom".equals(profile.getWeighting())) continue;
            throw new IllegalArgumentException("profile '" + profile.getName() + "' has a custom model but weighting=" + profile.getWeighting() + " was defined");
        }
        LinkedHashSet<String> chConfigSet = new LinkedHashSet<String>(this.chPreparationHandler.getCHProfiles().size());
        for (CHProfile chConfig : this.chPreparationHandler.getCHProfiles()) {
            boolean added = chConfigSet.add(chConfig.getProfile());
            if (!added) {
                throw new IllegalArgumentException("Duplicate CH reference to profile '" + chConfig.getProfile() + "'");
            }
            if (this.profilesByName.containsKey(chConfig.getProfile())) continue;
            throw new IllegalArgumentException("CH profile references unknown profile '" + chConfig.getProfile() + "'");
        }
        LinkedHashMap<String, LMProfile> linkedHashMap = new LinkedHashMap<String, LMProfile>(this.lmPreparationHandler.getLMProfiles().size());
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            LMProfile previous = linkedHashMap.put(lmProfile.getProfile(), lmProfile);
            if (previous != null) {
                throw new IllegalArgumentException("Multiple LM profiles are using the same profile '" + lmProfile.getProfile() + "'");
            }
            if (!this.profilesByName.containsKey(lmProfile.getProfile())) {
                throw new IllegalArgumentException("LM profile references unknown profile '" + lmProfile.getProfile() + "'");
            }
            if (!lmProfile.usesOtherPreparation() || this.profilesByName.containsKey(lmProfile.getPreparationProfile())) continue;
            throw new IllegalArgumentException("LM profile references unknown preparation profile '" + lmProfile.getPreparationProfile() + "'");
        }
        for (LMProfile lmConfig : this.lmPreparationHandler.getLMProfiles()) {
            if (lmConfig.usesOtherPreparation() && !linkedHashMap.containsKey(lmConfig.getPreparationProfile())) {
                throw new IllegalArgumentException("Unknown LM preparation profile '" + lmConfig.getPreparationProfile() + "' in LM profile '" + lmConfig.getProfile() + "' cannot be used as preparation_profile");
            }
            if (!lmConfig.usesOtherPreparation() || !((LMProfile)linkedHashMap.get(lmConfig.getPreparationProfile())).usesOtherPreparation()) continue;
            throw new IllegalArgumentException("Cannot use '" + lmConfig.getPreparationProfile() + "' as preparation_profile for LM profile '" + lmConfig.getProfile() + "', because it uses another profile for preparation itself.");
        }
    }

    public RoutingAlgorithmFactory getAlgorithmFactory(String profile, boolean disableCH, boolean disableLM) {
        if (this.chPreparationHandler.isEnabled() && disableCH && !this.chPreparationHandler.isDisablingAllowed()) {
            throw new IllegalArgumentException("Disabling CH is not allowed on the server side");
        }
        if (this.lmPreparationHandler.isEnabled() && disableLM && !this.lmPreparationHandler.isDisablingAllowed()) {
            throw new IllegalArgumentException("Disabling LM is not allowed on the server side");
        }
        if (this.chPreparationHandler.isEnabled() && !disableCH) {
            return this.chPreparationHandler.getAlgorithmFactory(profile);
        }
        if (this.lmPreparationHandler.isEnabled() && !disableLM) {
            for (LMProfile lmp : this.lmPreparationHandler.getLMProfiles()) {
                if (!lmp.getProfile().equals(profile)) continue;
                return lmp.usesOtherPreparation() ? this.lmPreparationHandler.getAlgorithmFactory(lmp.getPreparationProfile()) : this.lmPreparationHandler.getAlgorithmFactory(lmp.getProfile());
            }
            throw new IllegalArgumentException("Cannot find LM preparation for the requested profile: '" + profile + "'");
        }
        return new RoutingAlgorithmFactorySimple();
    }

    public final CHPreparationHandler getCHPreparationHandler() {
        return this.chPreparationHandler;
    }

    private void initCHPreparationHandler() {
        if (this.chPreparationHandler.hasCHConfigs()) {
            return;
        }
        for (CHProfile chConfig : this.chPreparationHandler.getCHProfiles()) {
            Profile profile = this.profilesByName.get(chConfig.getProfile());
            if (profile.isTurnCosts()) {
                this.chPreparationHandler.addCHConfig(CHConfig.edgeBased(profile.getName(), this.createWeighting(profile, new PMap())));
                continue;
            }
            this.chPreparationHandler.addCHConfig(CHConfig.nodeBased(profile.getName(), this.createWeighting(profile, new PMap())));
        }
    }

    public final LMPreparationHandler getLMPreparationHandler() {
        return this.lmPreparationHandler;
    }

    private void initLMPreparationHandler() {
        if (this.lmPreparationHandler.hasLMProfiles()) {
            return;
        }
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            if (lmProfile.usesOtherPreparation()) continue;
            Profile profile = this.profilesByName.get(lmProfile.getProfile());
            Weighting weighting = this.createWeighting(profile, new PMap(), true);
            this.lmPreparationHandler.addLMConfig(new LMConfig(profile.getName(), weighting));
        }
    }

    public final void postProcessing() {
        this.postProcessing(false);
    }

    protected void postProcessing(boolean closeEarly) {
        if (this.sortGraph) {
            if (this.ghStorage.isCHPossible() && this.isCHPrepared()) {
                throw new IllegalArgumentException("Sorting a prepared CHGraph is not possible yet. See #12");
            }
            GraphHopperStorage newGraph = GHUtility.newStorage(this.ghStorage);
            GHUtility.sortDFS(this.ghStorage, newGraph);
            this.logger.info("graph sorted (" + Helper.getMemInfo() + ")");
            this.ghStorage = newGraph;
        }
        if (!this.hasInterpolated() && this.hasElevation()) {
            this.interpolateBridgesAndOrTunnels();
        }
        this.initLocationIndex();
        this.importPublicTransit();
        if (this.lmPreparationHandler.isEnabled()) {
            this.lmPreparationHandler.createPreparations(this.ghStorage, this.locationIndex);
        }
        this.loadOrPrepareLM(closeEarly);
        if (this.chPreparationHandler.isEnabled()) {
            this.chPreparationHandler.createPreparations(this.ghStorage);
        }
        if (this.isCHPrepared()) {
            for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
                if (this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
                throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
            }
        } else {
            this.prepareCH(closeEarly);
        }
    }

    protected void registerCustomEncodedValues(EncodingManager.Builder emBuilder) {
    }

    protected void importPublicTransit() {
    }

    private boolean hasInterpolated() {
        return "true".equals(this.ghStorage.getProperties().get(INTERPOLATION_KEY));
    }

    void interpolateBridgesAndOrTunnels() {
        if (this.ghStorage.getEncodingManager().hasEncodedValue("road_environment")) {
            EnumEncodedValue<RoadEnvironment> roadEnvEnc = this.ghStorage.getEncodingManager().getEnumEncodedValue("road_environment", RoadEnvironment.class);
            StopWatch sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.TUNNEL).execute();
            float tunnel = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.ghStorage, roadEnvEnc, RoadEnvironment.BRIDGE).execute();
            this.ghStorage.getProperties().put(INTERPOLATION_KEY, true);
            this.logger.info("Bridge interpolation " + (int)sw.stop().getSeconds() + "s, tunnel interpolation " + (int)tunnel + "s");
        }
    }

    public final Weighting createWeighting(Profile profile, PMap hints) {
        return this.createWeighting(profile, hints, false);
    }

    public Weighting createWeighting(Profile profile, PMap hints, boolean disableTurnCosts) {
        return new DefaultWeightingFactory(this.ghStorage, this.encodingManager).createWeighting(profile, hints, disableTurnCosts);
    }

    public GHResponse route(GHRequest request) {
        GHResponse response = new GHResponse();
        this.calcPaths(request, response);
        return response;
    }

    public List<Path> calcPaths(GHRequest request, GHResponse ghRsp) {
        if (this.ghStorage == null || !this.fullyLoaded) {
            throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
        }
        if (this.ghStorage.isClosed()) {
            throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
        }
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        try {
            Weighting weighting;
            this.validateRequest(request);
            boolean disableCH = this.getDisableCH(request.getHints());
            boolean disableLM = this.getDisableLM(request.getHints());
            Profile profile = this.profilesByName.get(request.getProfile());
            if (profile == null) {
                throw new IllegalArgumentException("The requested profile '" + request.getProfile() + "' does not exist.\nAvailable profiles: " + this.profilesByName.keySet());
            }
            if (!profile.isTurnCosts() && !request.getCurbsides().isEmpty()) {
                throw new IllegalArgumentException("To make use of the curbside parameter you need to use a profile that supports turn costs\nThe following profiles do support turn costs: " + this.getTurnCostProfiles());
            }
            TraversalMode tMode = profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
            RoutingAlgorithmFactory algorithmFactory = this.getAlgorithmFactory(profile.getName(), disableCH, disableLM);
            Graph graph = this.ghStorage;
            if (this.chPreparationHandler.isEnabled() && !disableCH) {
                if (!(algorithmFactory instanceof CHRoutingAlgorithmFactory)) {
                    throw new IllegalStateException("Although CH was enabled a non-CH algorithm factory was returned " + algorithmFactory);
                }
                if (request.getHints().has("block_area")) {
                    throw new IllegalArgumentException("When CH is enabled the block_area cannot be specified");
                }
                CHConfig chConfig = ((CHRoutingAlgorithmFactory)algorithmFactory).getCHConfig();
                weighting = chConfig.getWeighting();
                graph = this.ghStorage.getCHGraph(chConfig);
            } else {
                this.checkNonChMaxWaypointDistance(request.getPoints());
                int uTurnCostsInt = request.getHints().getInt("u_turn_costs", -1);
                if (uTurnCostsInt != -1 && !tMode.isEdgeBased()) {
                    throw new IllegalArgumentException("Finite u-turn costs can only be used for edge-based routing, you need to use a profile thatsupports turn costs. Currently the following profiles that support turn costs are available: " + this.getTurnCostProfiles());
                }
                FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
                weighting = this.createWeighting(profile, request.getHints());
                if (request.getHints().has("block_area")) {
                    weighting = new BlockAreaWeighting(weighting, GraphEdgeIdFinder.createBlockArea(this.ghStorage, this.locationIndex, request.getPoints(), request.getHints(), DefaultEdgeFilter.allEdges(encoder)));
                }
            }
            ghRsp.addDebugInfo("tmode:" + tMode.toString());
            String algoStr = request.getAlgorithm();
            if (algoStr.isEmpty()) {
                algoStr = this.chPreparationHandler.isEnabled() && !disableCH ? "dijkstrabi" : "astarbi";
            }
            RoutingTemplate routingTemplate = this.createRoutingTemplate(request, ghRsp, algoStr, weighting);
            StopWatch sw = new StopWatch().start();
            List<QueryResult> qResults = routingTemplate.lookup(request.getPoints());
            ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
            if (ghRsp.hasErrors()) {
                return Collections.emptyList();
            }
            QueryGraph queryGraph = QueryGraph.create(graph, qResults);
            int maxVisitedNodesForRequest = request.getHints().getInt("max_visited_nodes", this.routingConfig.getMaxVisitedNodes());
            if (maxVisitedNodesForRequest > this.routingConfig.getMaxVisitedNodes()) {
                throw new IllegalArgumentException("The max_visited_nodes parameter has to be below or equal to:" + this.routingConfig.getMaxVisitedNodes());
            }
            AlgorithmOptions algoOpts = AlgorithmOptions.start().algorithm(algoStr).traversalMode(tMode).weighting(weighting).maxVisitedNodes(maxVisitedNodesForRequest).hints(request.getHints()).build();
            List<Path> altPaths = routingTemplate.calcPaths(queryGraph, algorithmFactory, algoOpts);
            boolean tmpEnableInstructions = request.getHints().getBool("instructions", this.encodingManager.isEnableInstructions());
            boolean tmpCalcPoints = request.getHints().getBool("calc_points", this.routingConfig.isCalcPoints());
            double wayPointMaxDistance = request.getHints().getDouble("way_point_max_distance", 1.0);
            DouglasPeucker peucker = new DouglasPeucker().setMaxDistance(wayPointMaxDistance);
            PathMerger pathMerger = new PathMerger(queryGraph.getBaseGraph(), weighting).setCalcPoints(tmpCalcPoints).setDouglasPeucker(peucker).setEnableInstructions(tmpEnableInstructions).setPathDetailsBuilders(this.pathBuilderFactory, request.getPathDetails()).setSimplifyResponse(this.routingConfig.isSimplifyResponse() && wayPointMaxDistance > 0.0);
            if (!request.getHeadings().isEmpty()) {
                pathMerger.setFavoredHeading((Double)request.getHeadings().get(0));
            }
            routingTemplate.finish(pathMerger, this.trMap.getWithFallBack(request.getLocale()));
            return altPaths;
        }
        catch (IllegalArgumentException ex) {
            ghRsp.addError((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private List<String> getTurnCostProfiles() {
        ArrayList<String> turnCostProfiles = new ArrayList<String>();
        for (Profile p : this.profilesByName.values()) {
            if (!p.isTurnCosts()) continue;
            turnCostProfiles.add(p.getName());
        }
        return turnCostProfiles;
    }

    protected void validateRequest(GHRequest request) {
        if (Helper.isEmpty((String)request.getProfile())) {
            throw new IllegalArgumentException("You need to specify a profile to perform a routing request, see docs/core/profiles.md");
        }
        if (request.getHints().has("vehicle")) {
            throw new IllegalArgumentException("GHRequest may no longer contain a vehicle, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("weighting")) {
            throw new IllegalArgumentException("GHRequest may no longer contain a weighting, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("turn_costs")) {
            throw new IllegalArgumentException("GHRequest may no longer contain the turn_costs=true/false parameter, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("edge_based")) {
            throw new IllegalArgumentException("GHRequest may no longer contain the edge_based=true/false parameter, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getPoints().isEmpty()) {
            throw new IllegalArgumentException("You have to pass at least one point");
        }
        this.checkIfPointsAreInBounds(request.getPoints());
        if (request.getHeadings().size() > 1 && request.getHeadings().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("The number of 'heading' parameters must be zero, one or equal to the number of points (" + request.getPoints().size() + ")");
        }
        for (int i = 0; i < request.getHeadings().size(); ++i) {
            if (GHRequest.isAzimuthValue((double)((Double)request.getHeadings().get(i)))) continue;
            throw new IllegalArgumentException("Heading for point " + i + " must be in range [0,360) or NaN, but was: " + request.getHeadings().get(i));
        }
        if (request.getPointHints().size() > 0 && request.getPointHints().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("If you pass point_hint, you need to pass exactly one hint for every point, empty hints will be ignored");
        }
        if (request.getCurbsides().size() > 0 && request.getCurbsides().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("If you pass curbside, you need to pass exactly one curbside for every point, empty curbsides will be ignored");
        }
        boolean disableCH = this.getDisableCH(request.getHints());
        if (this.chPreparationHandler.isEnabled() && !this.chPreparationHandler.isDisablingAllowed() && disableCH) {
            throw new IllegalArgumentException("Disabling CH not allowed on the server-side");
        }
        boolean disableLM = this.getDisableLM(request.getHints());
        if (this.lmPreparationHandler.isEnabled() && !this.lmPreparationHandler.isDisablingAllowed() && disableLM) {
            throw new IllegalArgumentException("Disabling LM not allowed on the server-side");
        }
        if (this.chPreparationHandler.isEnabled() && !disableCH) {
            if (!request.getHeadings().isEmpty()) {
                throw new IllegalArgumentException("The 'heading' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`. See issue #483");
            }
            if (request.getHints().getBool("pass_through", false)) {
                throw new IllegalArgumentException("The 'pass_through' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`. See issue #1765");
            }
        }
    }

    private boolean getDisableLM(PMap hints) {
        return hints.getBool("lm.disable", false);
    }

    private boolean getDisableCH(PMap hints) {
        return hints.getBool("ch.disable", false);
    }

    protected RoutingTemplate createRoutingTemplate(GHRequest request, GHResponse ghRsp, String algoStr, Weighting weighting) {
        AbstractRoutingTemplate routingTemplate = "round_trip".equalsIgnoreCase(algoStr) ? new RoundTripRoutingTemplate(request, ghRsp, this.locationIndex, this.encodingManager, weighting, this.routingConfig.getMaxRoundTripRetries()) : ("alternative_route".equalsIgnoreCase(algoStr) ? new AlternativeRoutingTemplate(request, ghRsp, this.locationIndex, this.encodingManager, weighting) : new ViaRoutingTemplate(request, ghRsp, this.locationIndex, this.encodingManager, weighting));
        return routingTemplate;
    }

    private void checkIfPointsAreInBounds(List<GHPoint> points) {
        BBox bounds = this.ghStorage.getBounds();
        for (int i = 0; i < points.size(); ++i) {
            GHPoint point = points.get(i);
            if (bounds.contains(point.getLat(), point.getLon())) continue;
            throw new PointOutOfBoundsException("Point " + i + " is out of bounds: " + point, i);
        }
    }

    private void checkNonChMaxWaypointDistance(List<GHPoint> points) {
        if (this.routingConfig.getNonChMaxWaypointDistance() == Integer.MAX_VALUE) {
            return;
        }
        GHPoint lastPoint = points.get(0);
        DistanceCalc calc = Helper.DIST_EARTH;
        for (int i = 1; i < points.size(); ++i) {
            GHPoint point = points.get(i);
            double dist = calc.calcDist(lastPoint.getLat(), lastPoint.getLon(), point.getLat(), point.getLon());
            if (dist > (double)this.routingConfig.getNonChMaxWaypointDistance()) {
                HashMap<String, Integer> detailMap = new HashMap<String, Integer>(2);
                detailMap.put("from", i - 1);
                detailMap.put("to", i);
                throw new PointDistanceExceededException("Point " + i + " is too far from Point " + (i - 1) + ": " + point, detailMap);
            }
            lastPoint = point;
        }
    }

    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.ghStorage, dir);
        tmpIndex.setResolution(this.preciseIndexResolution);
        tmpIndex.setMaxRegionSearch(this.maxRegionSearch);
        if (!tmpIndex.loadExisting()) {
            this.ensureWriteAccess();
            tmpIndex.prepareIndex();
        }
        return tmpIndex;
    }

    protected void initLocationIndex() {
        if (this.locationIndex != null) {
            throw new IllegalStateException("Cannot initialize locationIndex twice!");
        }
        this.locationIndex = this.createLocationIndex(this.ghStorage.getDirectory());
    }

    private boolean isCHPrepared() {
        return "true".equals(this.ghStorage.getProperties().get("prepare.ch.done"));
    }

    private String getProfileVersion(String profile) {
        return this.ghStorage.getProperties().get("graph.profiles." + profile + ".version");
    }

    private void setProfileVersion(String profile, int version) {
        this.ghStorage.getProperties().put("graph.profiles." + profile + ".version", version);
    }

    protected void prepareCH(boolean closeEarly) {
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (this.getProfileVersion(profile.getProfile()).isEmpty() || this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
            throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        boolean tmpPrepare = this.chPreparationHandler.isEnabled();
        if (tmpPrepare) {
            this.ensureWriteAccess();
            if (closeEarly) {
                this.locationIndex.flush();
                this.locationIndex.close();
                this.ghStorage.flushAndCloseEarly();
            }
            this.ghStorage.freeze();
            this.chPreparationHandler.prepare(this.ghStorage.getProperties(), closeEarly);
            this.ghStorage.getProperties().put("prepare.ch.done", true);
            for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
                this.setProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
            }
        }
    }

    protected void loadOrPrepareLM(boolean closeEarly) {
        boolean tmpPrepare;
        boolean bl = tmpPrepare = this.lmPreparationHandler.isEnabled() && !this.lmPreparationHandler.getPreparations().isEmpty();
        if (tmpPrepare) {
            for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
                if (this.getProfileVersion(profile.getProfile()).isEmpty() || this.getProfileVersion(profile.getProfile()).equals("" + this.profilesByName.get(profile.getProfile()).getVersion())) continue;
                throw new IllegalArgumentException("LM preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
            }
            this.ensureWriteAccess();
            this.ghStorage.freeze();
            if (this.lmPreparationHandler.loadOrDoWork(this.ghStorage.getProperties(), closeEarly)) {
                this.ghStorage.getProperties().put("prepare.lm.done", true);
                for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
                    this.setProfileVersion(profile.getProfile(), this.profilesByName.get(profile.getProfile()).getVersion());
                }
            }
        }
    }

    protected void cleanUp() {
        PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.ghStorage, this.buildSubnetworkRemovalJobs());
        preparation.setMinNetworkSize(this.minNetworkSize);
        preparation.doWork();
        this.logger.info("nodes: " + Helper.nf((long)this.ghStorage.getNodes()) + ", edges: " + Helper.nf((long)this.ghStorage.getEdges()));
    }

    private List<PrepareRoutingSubnetworks.PrepareJob> buildSubnetworkRemovalJobs() {
        List<FlagEncoder> encoders = this.encodingManager.fetchEdgeEncoders();
        ArrayList<PrepareRoutingSubnetworks.PrepareJob> jobs = new ArrayList<PrepareRoutingSubnetworks.PrepareJob>();
        for (FlagEncoder encoder : encoders) {
            if (encoder.supportsTurnCosts()) {
                DefaultTurnCostProvider turnCostProvider = new DefaultTurnCostProvider(encoder, this.ghStorage.getTurnCostStorage(), 0);
                jobs.add(new PrepareRoutingSubnetworks.PrepareJob(encoder.toString(), encoder.getAccessEnc(), turnCostProvider));
                continue;
            }
            jobs.add(new PrepareRoutingSubnetworks.PrepareJob(encoder.toString(), encoder.getAccessEnc(), null));
        }
        return jobs;
    }

    protected void flush() {
        this.logger.info("flushing graph " + this.ghStorage.toString() + ", details:" + this.ghStorage.toDetailsString() + ", " + Helper.getMemInfo() + ")");
        this.ghStorage.flush();
        this.logger.info("flushed graph " + Helper.getMemInfo() + ")");
        this.setFullyLoaded();
    }

    public void close() {
        if (this.ghStorage != null) {
            this.ghStorage.close();
        }
        if (this.locationIndex != null) {
            this.locationIndex.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.getGraphHopperLocation().isEmpty()) {
            throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
        }
        File folder = new File(this.getGraphHopperLocation());
        Helper.removeDir((File)folder);
    }

    protected void ensureNotLoaded() {
        if (this.fullyLoaded) {
            throw new IllegalStateException("No configuration changes are possible after loading the graph");
        }
    }

    protected void ensureWriteAccess() {
        if (!this.allowWrites) {
            throw new IllegalStateException("Writes are not allowed!");
        }
    }

    public void setNonChMaxWaypointDistance(int nonChMaxWaypointDistance) {
        this.routingConfig.setNonChMaxWaypointDistance(nonChMaxWaypointDistance);
    }

    private void setFullyLoaded() {
        this.fullyLoaded = true;
    }

    private static class RoutingConfig {
        private int maxVisitedNodes = Integer.MAX_VALUE;
        private int maxRoundTripRetries = 3;
        private int nonChMaxWaypointDistance = Integer.MAX_VALUE;
        private boolean calcPoints = true;
        private boolean simplifyResponse = true;

        private RoutingConfig() {
        }

        public int getMaxVisitedNodes() {
            return this.maxVisitedNodes;
        }

        public void setMaxVisitedNodes(int maxVisitedNodes) {
            this.maxVisitedNodes = maxVisitedNodes;
        }

        public int getMaxRoundTripRetries() {
            return this.maxRoundTripRetries;
        }

        public void setMaxRoundTripRetries(int maxRoundTripRetries) {
            this.maxRoundTripRetries = maxRoundTripRetries;
        }

        public int getNonChMaxWaypointDistance() {
            return this.nonChMaxWaypointDistance;
        }

        public void setNonChMaxWaypointDistance(int nonChMaxWaypointDistance) {
            this.nonChMaxWaypointDistance = nonChMaxWaypointDistance;
        }

        public boolean isCalcPoints() {
            return this.calcPoints;
        }

        public void setCalcPoints(boolean calcPoints) {
            this.calcPoints = calcPoints;
        }

        public boolean isSimplifyResponse() {
            return this.simplifyResponse;
        }

        public void setSimplifyResponse(boolean simplifyResponse) {
            this.simplifyResponse = simplifyResponse;
        }
    }

    private static class DefaultWeightingFactory {
        private final GraphHopperStorage ghStorage;
        private final EncodingManager encodingManager;

        public DefaultWeightingFactory(GraphHopperStorage ghStorage, EncodingManager encodingManager) {
            this.ghStorage = ghStorage;
            this.encodingManager = encodingManager;
        }

        public Weighting createWeighting(Profile profile, PMap requestHints, boolean disableTurnCosts) {
            TurnCostProvider turnCostProvider;
            PMap hints = new PMap();
            hints.putAll(profile.getHints());
            hints.putAll(requestHints);
            FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
            if (profile.isTurnCosts() && !disableTurnCosts) {
                if (!encoder.supportsTurnCosts()) {
                    throw new IllegalArgumentException("Encoder " + encoder + " does not support turn costs");
                }
                int uTurnCosts = hints.getInt("u_turn_costs", -1);
                turnCostProvider = new DefaultTurnCostProvider(encoder, this.ghStorage.getTurnCostStorage(), uTurnCosts);
            } else {
                turnCostProvider = TurnCostProvider.NO_TURN_COST_PROVIDER;
            }
            String weightingStr = Helper.toLowerCase((String)profile.getWeighting());
            if (weightingStr.isEmpty()) {
                throw new IllegalArgumentException("You have to specify a weighting");
            }
            AbstractWeighting weighting = null;
            if ("custom".equalsIgnoreCase(weightingStr)) {
                if (!(profile instanceof CustomProfile)) {
                    throw new IllegalArgumentException("custom weighting requires a CustomProfile but was profile=" + profile.getName());
                }
                CustomModel queryCustomModel = (CustomModel)requestHints.getObject("custom_model", null);
                CustomProfile customProfile = (CustomProfile)profile;
                queryCustomModel = queryCustomModel == null ? customProfile.getCustomModel() : CustomModel.merge((CustomModel)customProfile.getCustomModel(), (CustomModel)queryCustomModel);
                weighting = new CustomWeighting(encoder, this.encodingManager, turnCostProvider, queryCustomModel);
            } else if ("shortest".equalsIgnoreCase(weightingStr)) {
                weighting = new ShortestWeighting(encoder, turnCostProvider);
            } else if ("fastest".equalsIgnoreCase(weightingStr)) {
                weighting = encoder.supports(PriorityWeighting.class) ? new PriorityWeighting(encoder, hints, turnCostProvider) : new FastestWeighting(encoder, hints, turnCostProvider);
            } else if ("curvature".equalsIgnoreCase(weightingStr)) {
                if (encoder.supports(CurvatureWeighting.class)) {
                    weighting = new CurvatureWeighting(encoder, hints, turnCostProvider);
                }
            } else if ("short_fastest".equalsIgnoreCase(weightingStr)) {
                weighting = new ShortFastestWeighting(encoder, hints, turnCostProvider);
            }
            if (weighting == null) {
                throw new IllegalArgumentException("Weighting '" + weightingStr + "' not supported");
            }
            return weighting;
        }
    }
}

