/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.path;

import com.graphaware.module.algo.path.RelationshipCostFinder;
import org.neo4j.graphdb.Relationship;

public abstract class PropertyBasedRelationshipCostFinder
implements RelationshipCostFinder {
    private final String costPropertyKey;

    protected PropertyBasedRelationshipCostFinder(String costPropertyKey) {
        this.costPropertyKey = costPropertyKey;
    }

    @Override
    public long getCost(Relationship relationship) {
        if (!relationship.hasProperty(this.costPropertyKey)) {
            return this.getDefaultCost();
        }
        return this.objectToLong(relationship.getProperty(this.costPropertyKey));
    }

    private long objectToLong(Object value) {
        if (value instanceof Integer) {
            return new Integer((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return this.getDefaultCost();
    }

    protected abstract long getDefaultCost();
}

