/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.path;

import com.graphaware.module.algo.path.SortOrder;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;

public class PathFinderInput {
    private final Node start;
    private final Node end;
    private int maxDepth = 3;
    private int maxResults = Integer.MAX_VALUE;
    private final List<Object> typesAndDirections = new ArrayList<Object>();
    private Direction direction;
    private SortOrder sortOrder = SortOrder.LENGTH_ASC;
    private String costProperty;

    public PathFinderInput(Node start, Node end) {
        this.start = start;
        this.end = end;
    }

    public PathFinderInput setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public PathFinderInput setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public PathFinderInput setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    public PathFinderInput addType(RelationshipType type) {
        return this.addTypeAndDirection(type, Direction.BOTH);
    }

    public PathFinderInput addTypeAndDirection(RelationshipType type, Direction direction) {
        this.typesAndDirections.add(type);
        this.typesAndDirections.add(direction);
        return this;
    }

    public PathFinderInput setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public PathFinderInput setCostProperty(String costProperty) {
        this.costProperty = costProperty;
        return this;
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public PathExpander getExpander() {
        if (this.typesAndDirections.isEmpty()) {
            return PathExpanders.forDirection((Direction)(this.direction == null ? Direction.BOTH : this.direction));
        }
        if (this.typesAndDirections.size() == 2) {
            return PathExpanders.forTypeAndDirection((RelationshipType)((RelationshipType)this.typesAndDirections.get(0)), (Direction)((Direction)this.typesAndDirections.get(1)));
        }
        return PathExpanders.forTypesAndDirections((RelationshipType)((RelationshipType)this.typesAndDirections.get(0)), (Direction)((Direction)this.typesAndDirections.get(1)), (RelationshipType)((RelationshipType)this.typesAndDirections.get(2)), (Direction)((Direction)this.typesAndDirections.get(3)), (Object[])(this.typesAndDirections.size() > 3 ? this.typesAndDirections.subList(4, this.typesAndDirections.size()).toArray() : new Object[]{}));
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getCostProperty() {
        return this.costProperty;
    }
}

