/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.path;

import com.graphaware.module.algo.path.JsonPath;
import com.graphaware.module.algo.path.JsonPathFinderInput;
import com.graphaware.module.algo.path.NumberOfShortestPathsFinder;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/algorithm/path"})
public class NumberOfShortestPathsFinderApi {
    private final GraphDatabaseService database;
    private NumberOfShortestPathsFinder pathFinder = new NumberOfShortestPathsFinder();

    @Autowired
    public NumberOfShortestPathsFinderApi(GraphDatabaseService database) {
        this.database = database;
    }

    @RequestMapping(value={"increasinglyLongerShortestPath"}, method={RequestMethod.POST})
    @ResponseBody
    public List<JsonPath> numberOfShortestPaths(@RequestBody JsonPathFinderInput jsonInput) {
        LinkedList<JsonPath> result = new LinkedList<JsonPath>();
        try (Transaction tx = this.database.beginTx();){
            for (Path path : this.pathFinder.findPaths(jsonInput.produceInput(this.database))) {
                result.add(new JsonPath(path, jsonInput));
            }
            tx.success();
        }
        return result;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public void handleIllegalArguments() {
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handleNotFound() {
    }
}

