/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.path;

import com.graphaware.module.algo.path.LengthThenCostWeightedPathComparator;
import com.graphaware.module.algo.path.MaxLongDefaultingRelationshipCostFinder;
import com.graphaware.module.algo.path.PathCostCalculator;
import com.graphaware.module.algo.path.PathCostCalculatorImpl;
import com.graphaware.module.algo.path.PathFinderInput;
import com.graphaware.module.algo.path.SortOrder;
import com.graphaware.module.algo.path.WeightedPath;
import com.graphaware.module.algo.path.WeightedPathImpl;
import com.graphaware.module.algo.path.ZeroDefaultingRelationshipCostFinder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.helpers.collection.Iterables;

public class NumberOfShortestPathsFinder {
    public List<? extends Path> findPaths(PathFinderInput input) {
        List<Path> paths = this.findPathsSortedByLength(input);
        if (SortOrder.LENGTH_ASC.equals((Object)input.getSortOrder())) {
            return paths;
        }
        if (input.getCostProperty() == null) {
            throw new IllegalArgumentException("Cost property is null, but sort order is " + (Object)((Object)input.getSortOrder()));
        }
        switch (input.getSortOrder()) {
            case LENGTH_ASC_THEN_COST_ASC: {
                List<WeightedPath> weightedPaths = this.calculateCost(paths, new PathCostCalculatorImpl(new MaxLongDefaultingRelationshipCostFinder(input.getCostProperty())));
                Collections.sort(weightedPaths, new LengthThenCostWeightedPathComparator(LengthThenCostWeightedPathComparator.SortOrder.ASC));
                return weightedPaths;
            }
            case LENGTH_ASC_THEN_COST_DESC: {
                List<WeightedPath> weightedPaths = this.calculateCost(paths, new PathCostCalculatorImpl(new ZeroDefaultingRelationshipCostFinder(input.getCostProperty())));
                Collections.sort(weightedPaths, new LengthThenCostWeightedPathComparator(LengthThenCostWeightedPathComparator.SortOrder.DESC));
                return weightedPaths;
            }
        }
        throw new IllegalStateException("Illegal sort order " + (Object)((Object)input.getSortOrder()) + ". This is a bug");
    }

    private List<Path> findPathsSortedByLength(PathFinderInput input) {
        LinkedList<Path> result = new LinkedList<Path>();
        result.addAll(Iterables.asList((Iterable)GraphAlgoFactory.shortestPath((PathExpander)input.getExpander(), (int)input.getMaxDepth()).findAllPaths(input.getStart(), input.getEnd())));
        if (result.isEmpty() || result.size() >= input.getMaxResults()) {
            return result;
        }
        for (int depth = ((Path)result.get(0)).length() + 1; depth <= input.getMaxDepth() && result.size() < input.getMaxResults(); ++depth) {
            result.addAll(Iterables.asList((Iterable)GraphAlgoFactory.pathsWithLength((PathExpander)input.getExpander(), (int)depth).findAllPaths(input.getStart(), input.getEnd())));
        }
        return result;
    }

    private List<WeightedPath> calculateCost(List<Path> paths, PathCostCalculator costCalculator) {
        LinkedList<WeightedPath> result = new LinkedList<WeightedPath>();
        for (Path path : paths) {
            result.add(new WeightedPathImpl(path, costCalculator.calculateCost(path)));
        }
        return result;
    }
}

