/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.path;

import com.graphaware.api.SerializationSpecification;
import com.graphaware.api.json.JsonRelationshipTypeAndDirection;
import com.graphaware.module.algo.path.PathFinderInput;
import com.graphaware.module.algo.path.SortOrder;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;

public class JsonPathFinderInput
extends SerializationSpecification {
    private Long startNode;
    private Long endNode;
    private Integer maxDepth;
    private Integer maxResults;
    private List<JsonRelationshipTypeAndDirection> typesAndDirections;
    private Direction direction;
    private SortOrder sortOrder;
    private String costProperty;

    public PathFinderInput produceInput(GraphDatabaseService database) {
        if (this.getStartNode() == null || this.getEndNode() == null) {
            throw new IllegalArgumentException("Must specify at least start and end nodes!");
        }
        PathFinderInput input = new PathFinderInput(database.getNodeById(this.getStartNode().longValue()), database.getNodeById(this.getEndNode().longValue()));
        if (this.getSortOrder() != null) {
            input.setSortOrder(this.getSortOrder());
        }
        if (this.getCostProperty() != null) {
            input.setCostProperty(this.getCostProperty());
        }
        if (this.getMaxResults() != null) {
            input.setMaxResults(this.getMaxResults());
        }
        if (this.getDirection() != null) {
            input.setDirection(this.getDirection());
        }
        if (this.getMaxDepth() != null) {
            input.setMaxDepth(this.getMaxDepth());
        }
        if (this.getTypesAndDirections() != null) {
            if (this.getDirection() != null) {
                throw new IllegalArgumentException("Must specify either global direction, or specific types and directions, not both!");
            }
            for (JsonRelationshipTypeAndDirection typeAndDirection : this.getTypesAndDirections()) {
                input.addTypeAndDirection((RelationshipType)DynamicRelationshipType.withName((String)typeAndDirection.getType()), typeAndDirection.getDirection());
            }
        }
        return input;
    }

    public Long getStartNode() {
        return this.startNode;
    }

    public void setStartNode(Long startNode) {
        this.startNode = startNode;
    }

    public Long getEndNode() {
        return this.endNode;
    }

    public void setEndNode(Long endNode) {
        this.endNode = endNode;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public List<JsonRelationshipTypeAndDirection> getTypesAndDirections() {
        return this.typesAndDirections;
    }

    public void setTypesAndDirections(List<JsonRelationshipTypeAndDirection> typesAndDirections) {
        this.typesAndDirections = typesAndDirections;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getCostProperty() {
        return this.costProperty;
    }

    public void setCostProperty(String costProperty) {
        this.costProperty = costProperty;
    }
}

