/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.path;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.graphaware.api.json.JsonNode;
import com.graphaware.api.json.JsonRelationship;
import com.graphaware.api.json.LongIdJsonNode;
import com.graphaware.api.json.LongIdJsonRelationship;
import com.graphaware.module.algo.path.JsonPathFinderInput;
import com.graphaware.module.algo.path.WeightedPath;
import java.util.LinkedList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JsonPath {
    private JsonNode[] nodes;
    private JsonRelationship[] relationships;
    private Long cost;

    public JsonPath(Path path, JsonPathFinderInput jsonInput) {
        LinkedList<LongIdJsonNode> jsonNodes = new LinkedList<LongIdJsonNode>();
        for (Node node : path.nodes()) {
            jsonNodes.add(new LongIdJsonNode(node, jsonInput.getNodeProperties()));
        }
        LinkedList<LongIdJsonRelationship> jsonRelationships = new LinkedList<LongIdJsonRelationship>();
        for (Relationship relationship : path.relationships()) {
            jsonRelationships.add(new LongIdJsonRelationship(relationship, jsonInput.getRelationshipProperties()));
        }
        this.setNodes(jsonNodes.toArray(new JsonNode[jsonNodes.size()]));
        this.setRelationships(jsonRelationships.toArray(new JsonRelationship[jsonRelationships.size()]));
        if (path instanceof WeightedPath) {
            this.setCost(((WeightedPath)path).getCost());
        }
    }

    public JsonNode[] getNodes() {
        return this.nodes;
    }

    public void setNodes(JsonNode[] nodes) {
        this.nodes = nodes;
    }

    public JsonRelationship[] getRelationships() {
        return this.relationships;
    }

    public void setRelationships(JsonRelationship[] relationships) {
        this.relationships = relationships;
    }

    public Long getCost() {
        return this.cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }
}

