/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.relationship;

import com.graphaware.module.algo.generator.relationship.RelationshipCreator;
import java.util.Collections;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.unsafe.batchinsert.BatchInserter;

public class SocialNetworkRelationshipCreator
implements RelationshipCreator {
    private static final RelationshipType FRIEND_OF = RelationshipType.withName((String)"FRIEND_OF");
    private static final SocialNetworkRelationshipCreator INSTANCE = new SocialNetworkRelationshipCreator();

    private SocialNetworkRelationshipCreator() {
    }

    public static SocialNetworkRelationshipCreator getInstance() {
        return INSTANCE;
    }

    @Override
    public Relationship createRelationship(Node first, Node second) {
        return first.createRelationshipTo(second, FRIEND_OF);
    }

    @Override
    public long createRelationship(long first, long second, BatchInserter batchInserter) {
        return batchInserter.createRelationship(first, second, FRIEND_OF, Collections.EMPTY_MAP);
    }
}

