/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator.relationship;

import com.graphaware.common.util.SameTypePair;
import com.graphaware.common.util.UnorderedPair;
import com.graphaware.module.algo.generator.config.BarabasiAlbertConfig;
import com.graphaware.module.algo.generator.config.NumberOfNodesBasedConfig;
import com.graphaware.module.algo.generator.relationship.BaseRelationshipGenerator;
import com.graphaware.module.algo.generator.relationship.CompleteGraphRelationshipGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class BarabasiAlbertRelationshipGenerator
extends BaseRelationshipGenerator<BarabasiAlbertConfig> {
    private final Random random = new Random();

    public BarabasiAlbertRelationshipGenerator(BarabasiAlbertConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<SameTypePair<Integer>> doGenerateEdges() {
        int edgesPerNewNode = ((BarabasiAlbertConfig)this.getConfiguration()).getEdgesPerNewNode();
        int numberOfNodes = ((BarabasiAlbertConfig)this.getConfiguration()).getNumberOfNodes();
        List<SameTypePair<Integer>> edges = new CompleteGraphRelationshipGenerator(new NumberOfNodesBasedConfig(edgesPerNewNode + 1)).doGenerateEdges();
        HashSet<Integer> omit = new HashSet<Integer>(edgesPerNewNode);
        for (int source = edgesPerNewNode + 1; source < numberOfNodes; ++source) {
            omit.clear();
            for (int edge = 0; edge < edgesPerNewNode; ++edge) {
                int target;
                do {
                    SameTypePair<Integer> randomEdge = edges.get(this.random.nextInt(edges.size()));
                    int n = target = this.random.nextBoolean() ? ((Integer)randomEdge.first()).intValue() : ((Integer)randomEdge.second()).intValue();
                } while (omit.contains(target));
                omit.add(target);
                edges.add((SameTypePair<Integer>)new UnorderedPair((Object)target, (Object)source));
            }
        }
        return edges;
    }
}

