/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator;

import com.graphaware.common.util.SameTypePair;
import com.graphaware.module.algo.generator.BaseGraphGenerator;
import com.graphaware.module.algo.generator.config.GeneratorConfiguration;
import com.graphaware.module.algo.generator.relationship.RelationshipGenerator;
import com.graphaware.tx.executor.NullItem;
import com.graphaware.tx.executor.batch.IterableInputBatchTransactionExecutor;
import com.graphaware.tx.executor.batch.NoInputBatchTransactionExecutor;
import com.graphaware.tx.executor.batch.UnitOfWork;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;

public class Neo4jGraphGenerator
extends BaseGraphGenerator {
    private final GraphDatabaseService database;

    public Neo4jGraphGenerator(GraphDatabaseService database) {
        this.database = database;
    }

    @Override
    protected List<Long> generateNodes(final GeneratorConfiguration config) {
        final ArrayList<Long> nodes = new ArrayList<Long>();
        int numberOfNodes = config.getNumberOfNodes();
        NoInputBatchTransactionExecutor executor = new NoInputBatchTransactionExecutor(this.database, config.getBatchSize(), numberOfNodes, (UnitOfWork)new UnitOfWork<NullItem>(){

            public void execute(GraphDatabaseService database, NullItem input, int batchNumber, int stepNumber) {
                nodes.add(config.getNodeCreator().createNode(database).getId());
            }
        });
        executor.execute();
        return nodes;
    }

    @Override
    protected void generateRelationships(final GeneratorConfiguration config, final List<Long> nodes) {
        RelationshipGenerator<?> relationshipGenerator = config.getRelationshipGenerator();
        List<SameTypePair<Integer>> relationships = relationshipGenerator.generateEdges();
        IterableInputBatchTransactionExecutor executor = new IterableInputBatchTransactionExecutor(this.database, config.getBatchSize(), relationships, (UnitOfWork)new UnitOfWork<SameTypePair<Integer>>(){

            public void execute(GraphDatabaseService database, SameTypePair<Integer> input, int batchNumber, int stepNumber) {
                Node first = database.getNodeById(((Long)nodes.get((Integer)input.first())).longValue());
                Node second = database.getNodeById(((Long)nodes.get((Integer)input.second())).longValue());
                config.getRelationshipCreator().createRelationship(first, second);
            }
        });
        executor.execute();
    }
}

