/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.module.algo.generator;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.common.util.SameTypePair;
import com.graphaware.module.algo.generator.BaseGraphGenerator;
import com.graphaware.module.algo.generator.config.GeneratorConfiguration;
import com.graphaware.module.algo.generator.node.NodeCreator;
import com.graphaware.module.algo.generator.relationship.RelationshipCreator;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.logging.Log;
import org.neo4j.unsafe.batchinsert.BatchInserter;

public class BatchGraphGenerator
extends BaseGraphGenerator {
    private static final Log LOG = LoggerFactory.getLogger(BatchGraphGenerator.class);
    private final BatchInserter batchInserter;

    public BatchGraphGenerator(BatchInserter batchInserter) {
        this.batchInserter = batchInserter;
    }

    @Override
    public void generateGraph(GeneratorConfiguration configuration) {
        super.generateGraph(configuration);
        this.batchInserter.shutdown();
        LOG.info("Inserter shut down");
    }

    @Override
    protected List<Long> generateNodes(GeneratorConfiguration config) {
        ArrayList<Long> nodes = new ArrayList<Long>();
        int numberOfNodes = config.getNumberOfNodes();
        NodeCreator nodeCreator = config.getNodeCreator();
        LOG.info("Creating " + numberOfNodes + " nodes");
        for (int i = 0; i < numberOfNodes; ++i) {
            nodes.add(nodeCreator.createNode(this.batchInserter));
        }
        LOG.info("Created " + numberOfNodes + " nodes");
        return nodes;
    }

    @Override
    protected void generateRelationships(GeneratorConfiguration config, List<Long> nodes) {
        LOG.info("Generating relationships");
        List<SameTypePair<Integer>> relationships = config.getRelationshipGenerator().generateEdges();
        LOG.info("Generated relationships, creating them");
        RelationshipCreator relationshipCreator = config.getRelationshipCreator();
        for (SameTypePair<Integer> relationship : relationships) {
            relationshipCreator.createRelationship(nodes.get((Integer)relationship.first()), nodes.get((Integer)relationship.second()), this.batchInserter);
        }
        LOG.info("Created relationships, shutting down inserter");
    }
}

