/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.internal.UtilsKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocationContextKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ResourceTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.jetbrains.annotations.NotNull;

@CacheableTransformer
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J,\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/ResourceTransformer;", "<init>", "()V", "module", "Ljava/util/Properties;", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "handle", "key", "", "value", "mergeValue", "Lkotlin/Function1;", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nGroovyExtensionModuleTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyExtensionModuleTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n+ 4 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt$zipEntry$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n216#2,2:98\n30#3,15:100\n45#3:116\n34#4:115\n1#5:117\n*S KotlinDebug\n*F\n+ 1 GroovyExtensionModuleTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer\n*L\n42#1:98,2\n65#1:100,15\n65#1:116\n65#1:115\n*E\n"})
public class GroovyExtensionModuleTransformer
implements ResourceTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties module = new Properties();
    @NotNull
    public static final String PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR = "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule";
    @NotNull
    public static final String PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR = "META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule";
    @NotNull
    public static final String KEY_MODULE_NAME = "moduleName";
    @NotNull
    public static final String KEY_MODULE_VERSION = "moduleVersion";
    @NotNull
    public static final String KEY_EXTENSION_CLASSES = "extensionClasses";
    @NotNull
    public static final String KEY_STATIC_EXTENSION_CLASSES = "staticExtensionClasses";
    @NotNull
    public static final String MERGED_MODULE_NAME = "MergedByShadowJar";
    @NotNull
    public static final String MERGED_MODULE_VERSION = "1.0.0";

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        return Intrinsics.areEqual((Object)path, (Object)PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR) || Intrinsics.areEqual((Object)path, (Object)PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR);
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Properties props = new Properties();
        props.load(context.getInputStream());
        Map $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Object key = entry.getKey();
            Object value = entry.getValue();
            Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type kotlin.String");
            switch ((String)key) {
                case "moduleName": {
                    String string = (String)key;
                    Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                    this.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$0$0(this, key, arg_0)));
                    break;
                }
                case "moduleVersion": {
                    String string = (String)key;
                    Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                    this.handle(string, (String)value, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$0$1(this, key, arg_0)));
                    break;
                }
                case "staticExtensionClasses": 
                case "extensionClasses": {
                    Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.String");
                    char[] cArray = new char[]{','};
                    String relocatedClasses = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)((String)value), (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)",", null, null, (int)0, null, arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$0$2(context, arg_0), (int)30, null);
                    this.handle((String)key, relocatedClasses, (Function1<? super String, Unit>)((Function1)arg_0 -> GroovyExtensionModuleTransformer.transform$lambda$0$3(this, key, relocatedClasses, arg_0)));
                }
            }
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !((Map)this.module).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        void name$iv;
        ZipEntry zipEntry2;
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Object object = PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR;
        boolean preserveLastModified$iv = preserveFileTimestamps;
        long lastModified$iv = -1L;
        boolean $i$f$zipEntry = false;
        ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
        boolean bl = false;
        if (preserveLastModified$iv) {
            if (lastModified$iv >= 0L) {
                $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
            }
        } else {
            $this$zipEntry_u24lambda_u240$iv.setTime(ShadowCopyAction.Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
        }
        ZipEntry zipEntry3 = $this$zipEntry_u24lambda_u240$iv;
        ZipOutputStream zipOutputStream = os;
        boolean bl2 = false;
        ZipEntry zipEntry4 = zipEntry3;
        zipOutputStream.putNextEntry(zipEntry2);
        object = UtilsKt.inputStream$default(this.module, null, null, 3, null);
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)object;
            boolean bl3 = false;
            long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)os), (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        os.closeEntry();
    }

    private final void handle(String key, String value, Function1<? super String, Unit> mergeValue) {
        String existingValue = this.module.getProperty(key);
        if (existingValue != null) {
            mergeValue.invoke((Object)existingValue);
        } else {
            this.module.setProperty(key, value);
        }
    }

    private static final Unit transform$lambda$0$0(GroovyExtensionModuleTransformer this$0, Object $key, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.module.setProperty((String)$key, MERGED_MODULE_NAME);
        return Unit.INSTANCE;
    }

    private static final Unit transform$lambda$0$1(GroovyExtensionModuleTransformer this$0, Object $key, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.module.setProperty((String)$key, MERGED_MODULE_VERSION);
        return Unit.INSTANCE;
    }

    private static final CharSequence transform$lambda$0$2(TransformerContext $context, String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return RelocationContextKt.relocateClass((Iterable<? extends Relocator>)$context.getRelocators(), className);
    }

    private static final Unit transform$lambda$0$3(GroovyExtensionModuleTransformer this$0, Object $key, String $relocatedClasses, String existingValue) {
        Intrinsics.checkNotNullParameter((Object)existingValue, (String)"existingValue");
        this$0.module.setProperty((String)$key, existingValue + "," + $relocatedClasses);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/GroovyExtensionModuleTransformer$Companion;", "", "<init>", "()V", "PATH_LEGACY_GROOVY_EXTENSION_MODULE_DESCRIPTOR", "", "PATH_GROOVY_EXTENSION_MODULE_DESCRIPTOR", "KEY_MODULE_NAME", "KEY_MODULE_VERSION", "KEY_EXTENSION_CLASSES", "KEY_STATIC_EXTENSION_CLASSES", "MERGED_MODULE_NAME", "MERGED_MODULE_VERSION", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

