/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.relocation.RelocationContextKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ResourceTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.file.FileTreeElement;
import org.jetbrains.annotations.NotNull;

@CacheableTransformer
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0015\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/Log4j2PluginsCacheFileTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/ResourceTransformer;", "<init>", "()V", "tempFiles", "", "Ljava/nio/file/Path;", "tempRelocators", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "hasTransformedResource", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "relocatePlugins", "pluginCache", "Lorg/apache/logging/log4j/core/config/plugins/processor/PluginCache;", "relocatePlugins$shadow", "deleteTempFiles", "urlEnumeration", "Ljava/util/Enumeration;", "Ljava/net/URL;", "getUrlEnumeration", "()Ljava/util/Enumeration;", "shadow"})
@SourceDebugExtension(value={"SMAP\nLog4j2PluginsCacheFileTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Log4j2PluginsCacheFileTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/Log4j2PluginsCacheFileTransformer\n+ 2 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n+ 3 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt$zipEntry$1\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n36#2,14:95\n50#2:110\n40#3:109\n1869#4:111\n1869#4:112\n295#4,2:113\n1870#4:115\n1870#4:116\n1563#4:117\n1634#4,3:118\n*S KotlinDebug\n*F\n+ 1 Log4j2PluginsCacheFileTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/Log4j2PluginsCacheFileTransformer\n*L\n58#1:95,14\n58#1:110\n58#1:109\n68#1:111\n69#1:112\n71#1:113,2\n69#1:115\n68#1:116\n90#1:117\n90#1:118,3\n*E\n"})
public class Log4j2PluginsCacheFileTransformer
implements ResourceTransformer {
    @NotNull
    private final List<Path> tempFiles = new ArrayList();
    @NotNull
    private final List<Relocator> tempRelocators = new ArrayList();

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)"META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat", (Object)element.getPath());
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempFile("Log4j2Plugins", ".dat", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
        Path temporaryFile = path;
        this.tempFiles.add(temporaryFile);
        InputStream inputStream = context.getInputStream();
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(temporaryFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
        this.tempRelocators.addAll((Collection<Relocator>)context.getRelocators());
    }

    @Override
    public boolean hasTransformedResource() {
        return !((Collection)this.tempFiles).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        try {
            void name$iv;
            ZipEntry zipEntry2;
            PluginCache aggregator = new PluginCache();
            aggregator.loadCacheFiles(this.getUrlEnumeration());
            this.relocatePlugins$shadow(aggregator);
            String string = "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
            boolean preserveLastModified$iv = preserveFileTimestamps;
            long lastModified$iv = -1L;
            boolean $i$f$zipEntry = false;
            ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
            boolean bl = false;
            if (preserveLastModified$iv) {
                if (lastModified$iv >= 0L) {
                    $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
                }
            } else {
                $this$zipEntry_u24lambda_u240$iv.setTime(ShadowCopyAction.Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
            }
            ZipEntry zipEntry3 = $this$zipEntry_u24lambda_u240$iv;
            ZipOutputStream zipOutputStream = os;
            boolean bl2 = false;
            ZipEntry zipEntry4 = zipEntry3;
            zipOutputStream.putNextEntry(zipEntry2);
            aggregator.writeCache((OutputStream)CloseShieldOutputStream.wrap((OutputStream)((OutputStream)os)));
        }
        finally {
            this.deleteTempFiles();
            os.closeEntry();
        }
    }

    public final void relocatePlugins$shadow(@NotNull PluginCache pluginCache) {
        Intrinsics.checkNotNullParameter((Object)pluginCache, (String)"pluginCache");
        Iterable $this$forEach$iv = pluginCache.getAllCategories().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map currentMap = (Map)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = currentMap.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Relocator relocator;
                Object v0;
                String className;
                PluginEntry currentPluginEntry;
                block3: {
                    currentPluginEntry = (PluginEntry)element$iv2;
                    boolean bl2 = false;
                    className = currentPluginEntry.getClassName();
                    Iterable $this$firstOrNull$iv = this.tempRelocators;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        Relocator it = (Relocator)element$iv3;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)className);
                        if (!it.canRelocateClass(className)) continue;
                        v0 = element$iv3;
                        break block3;
                    }
                    v0 = null;
                }
                if ((Relocator)v0 == null) continue;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)className);
                currentPluginEntry.setClassName(RelocationContextKt.relocateClass(relocator, className));
            }
        }
    }

    private final void deleteTempFiles() {
        ListIterator<Path> pathIterator = this.tempFiles.listIterator();
        while (pathIterator.hasNext()) {
            Path path = pathIterator.next();
            Files.deleteIfExists(path);
            pathIterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Enumeration<URL> getUrlEnumeration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tempFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toUri().toURL());
        }
        List urls = (List)destination$iv$iv;
        Enumeration<URL> enumeration = Collections.enumeration(urls);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"enumeration(...)");
        return enumeration;
    }
}

