/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.session;

import com.google.code.rees.scope.session.SessionAdapter;
import com.google.code.rees.scope.session.SessionField;
import com.google.code.rees.scope.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionUtil.class);

    public static String buildKey(String name, Class<?> clazz) {
        return clazz.getName() + "." + name;
    }

    public static <T> T getField(String name, Class<T> clazz) {
        String key = SessionUtil.buildKey(name, clazz);
        SessionAdapter adapter = SessionAdapter.getAdapter();
        if (adapter == null) {
            return null;
        }
        Map<String, Object> sessionContext = adapter.getSessionContext();
        return (T)sessionContext.get(key);
    }

    public static void setField(String name, Object sessionField) {
        String key = SessionUtil.buildKey(name, sessionField.getClass());
        SessionAdapter adapter = SessionAdapter.getAdapter();
        if (adapter != null) {
            Map<String, Object> sessionContext = adapter.getSessionContext();
            sessionContext.put(key, sessionField);
        }
    }

    public static void extractFields(Object target) {
        Class<?> clazz = target.getClass();
        for (Field field : ReflectionUtil.getFields(clazz)) {
            if (!field.isAnnotationPresent(SessionField.class)) continue;
            String name = SessionUtil.getSessionFieldName(field);
            ReflectionUtil.makeAccessible(field);
            try {
                Object value = field.get(target);
                if (value == null) continue;
                SessionUtil.setField(name, value);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Illegal Argument on session field " + field.getName());
            }
            catch (IllegalAccessException e) {
                LOG.info("Illegal Access on session field " + field.getName());
            }
        }
    }

    public static void injectFields(Object target) {
        for (Field field : ReflectionUtil.getFields(target.getClass())) {
            if (!field.isAnnotationPresent(SessionField.class)) continue;
            Object value = SessionUtil.getField(field.getName(), field.getType());
            ReflectionUtil.makeAccessible(field);
            try {
                field.set(target, value);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Illegal Argument on session field " + field.getName());
            }
            catch (IllegalAccessException e) {
                LOG.info("Illegal Access on session field " + field.getName());
            }
        }
    }

    protected static String getSessionFieldName(Field field) {
        String name = field.getAnnotation(SessionField.class).name();
        if (name.equals("default")) {
            name = field.getName();
        }
        return name;
    }
}

