/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.processing;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.processing.ConversationPostProcessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationEndProcessor
implements ConversationPostProcessor {
    private static final long serialVersionUID = 2164492176500215404L;
    private static final Logger LOG = LoggerFactory.getLogger(ConversationEndProcessor.class);

    @Override
    public void postProcessConversation(ConversationAdapter conversationAdapter, ConversationClassConfiguration conversationConfig, String conversationId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("In Conversation " + conversationConfig.getConversationName() + ", removing conversation map from session following conversation end.");
        }
        String conversationName = null;
        if (conversationConfig == null) {
            for (Map.Entry<String, String> nameIdPair : conversationAdapter.getRequestContext().entrySet()) {
                if (!nameIdPair.getValue().equals(conversationId)) continue;
                conversationName = nameIdPair.getKey();
                break;
            }
        } else {
            conversationName = conversationConfig.getConversationName();
        }
        conversationAdapter.endConversation(conversationName, conversationId);
    }
}

