/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.context;

import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.context.DefaultConversationContextManager;
import com.google.code.rees.scope.util.monitor.TimeoutListener;
import com.google.code.rees.scope.util.monitor.TimeoutMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutConversationContextManager
extends DefaultConversationContextManager
implements TimeoutListener<ConversationContext> {
    private static final long serialVersionUID = -4431057690602876686L;
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutConversationContextManager.class);
    protected TimeoutMonitor<ConversationContext> conversationTimeoutMonitor;

    public void setTimeoutMonitor(TimeoutMonitor<ConversationContext> conversationTimeoutMonitor) {
        this.conversationTimeoutMonitor = conversationTimeoutMonitor;
    }

    @Override
    public ConversationContext createContext(String conversationName, long maxIdleTimeMillis) {
        ConversationContext context = super.createContext(conversationName, maxIdleTimeMillis);
        context.addTimeoutListener(this);
        this.conversationTimeoutMonitor.addTimeoutable(context);
        return context;
    }

    @Override
    public ConversationContext remove(String conversationName, String conversationId) {
        ConversationContext context = super.remove(conversationName, conversationId);
        if (context != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Conversation has ended, removing from TimeoutMonitor:  " + conversationName + " with ID " + conversationId);
            }
            this.conversationTimeoutMonitor.removeTimeoutable(context);
        }
        return context;
    }

    @Override
    public void onTimeout(ConversationContext expiredConversation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Conversation has timed out:  " + expiredConversation.getConversationName() + " with ID " + expiredConversation.getId());
        }
        super.remove(expiredConversation.getConversationName(), expiredConversation.getId());
    }

    @Override
    public void destroy() {
        LOG.debug("Destroying TimeoutConversationContextManager.");
        super.destroy();
        LOG.debug("Destroying TimeoutMonitor.");
        this.conversationTimeoutMonitor.destroy();
        LOG.debug("TimeoutConversationContextManager and TimeoutMonitor destroyed.");
    }
}

