/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util.thread;

import com.google.code.rees.scope.util.thread.AbstractEasyThread;
import com.google.code.rees.scope.util.thread.TaskThread;
import com.google.code.rees.scope.util.thread.ThreadTask;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class BasicTaskThread
extends AbstractEasyThread
implements TaskThread {
    protected Set<ThreadTask> tasks = new CopyOnWriteArraySet<ThreadTask>();

    protected BasicTaskThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(ThreadTask task) {
        Set<ThreadTask> set = this.tasks;
        synchronized (set) {
            this.tasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTask(ThreadTask task) {
        Set<ThreadTask> set = this.tasks;
        synchronized (set) {
            this.tasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        Set<ThreadTask> set = this.tasks;
        synchronized (set) {
            for (ThreadTask task : this.tasks) {
                task.cancel();
            }
            this.tasks.clear();
        }
    }

    @Override
    protected void doWhileRunning() {
        Iterator<ThreadTask> taskIterator = this.tasks.iterator();
        HashSet<ThreadTask> deadTasks = new HashSet<ThreadTask>();
        while (taskIterator.hasNext()) {
            ThreadTask task = taskIterator.next();
            if (task.isActive()) {
                task.doTask();
                continue;
            }
            deadTasks.add(task);
        }
        if (deadTasks.size() > 0) {
            this.tasks.removeAll(deadTasks);
        }
    }

    public static BasicTaskThread spawnInstance() {
        BasicTaskThread basicTaskThread = new BasicTaskThread();
        basicTaskThread.start();
        return basicTaskThread;
    }
}

