/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util;

import com.opensymphony.xwork2.ActionSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ReflectionUtil {
    public static Set<Field> getFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && !superClass.equals(ActionSupport.class)) {
            fields.addAll(ReflectionUtil.getFields(superClass));
        }
        return fields;
    }

    public static Set<Method> getMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && !superClass.equals(ActionSupport.class)) {
            methods.addAll(ReflectionUtil.getMethods(superClass));
        }
        return methods;
    }

    public static Set<Class<?>> getClasses(Class<?> clazz) {
        HashSet classes = new HashSet();
        classes.addAll(Arrays.asList(clazz.getDeclaredClasses()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            classes.addAll(ReflectionUtil.getClasses(superClass));
        }
        return classes;
    }

    public static <T extends Annotation> Set<T> getAnnotationInstances(Class<?> clazz, Class<T> annotationClass) {
        Class<?> superClass;
        HashSet<T> annotationInstances = new HashSet<T>();
        for (Class<?> clazzClass : clazz.getInterfaces()) {
            if (!clazzClass.isAnnotationPresent(annotationClass)) continue;
            annotationInstances.add(clazzClass.getAnnotation(annotationClass));
        }
        if (clazz.isAnnotationPresent(annotationClass)) {
            annotationInstances.add(clazz.getAnnotation(annotationClass));
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            annotationInstances.addAll(ReflectionUtil.getAnnotationInstances(superClass, annotationClass));
        }
        return annotationInstances;
    }

    public static void makeAccessible(Field field) {
        if (Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            return;
        }
        field.setAccessible(true);
    }
}

