/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2.test;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.ConversationUtil;
import com.google.code.rees.scope.conversation.configuration.DefaultConversationArbitrator;
import com.google.code.rees.scope.conversation.processing.ConversationProcessor;
import com.google.code.rees.scope.conversation.processing.DefaultInjectionConversationProcessor;
import com.google.code.rees.scope.session.SessionUtil;
import com.opensymphony.xwork2.ActionContext;
import java.util.Map;
import org.apache.struts2.dispatcher.Dispatcher;
import org.springframework.mock.web.MockHttpServletRequest;

public class ScopeTestUtil {
    private static DefaultInjectionConversationProcessor manager;
    private static DefaultConversationArbitrator arbitrator;
    private static String actionSuffix;

    protected static DefaultInjectionConversationProcessor getconversationManager() {
        if (manager == null) {
            manager = (DefaultInjectionConversationProcessor)Dispatcher.getInstance().getContainer().getInstance(ConversationProcessor.class, "struts.conversation.conversationProcessor");
        }
        return manager;
    }

    protected static String getActionSuffix() {
        if (actionSuffix == null) {
            actionSuffix = (String)Dispatcher.getInstance().getContainer().getInstance(String.class, "struts.convention.action.suffix");
        }
        return actionSuffix;
    }

    public static void setConversationIdsOnRequest(MockHttpServletRequest request, Class<?> actionClass) {
        ActionContext actionContext = ActionContext.getContext();
        Map convoIdMap = (Map)actionContext.getValueStack().findValue("conversationIdMapStackKey");
        if (convoIdMap != null) {
            for (Map.Entry entry : convoIdMap.entrySet()) {
                request.addParameter((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
        } else {
            for (String conversationName : arbitrator.getConversations(actionClass, ScopeTestUtil.getActionSuffix())) {
                request.addParameter(ConversationUtil.sanitizeName(conversationName) + "_conversation", conversationName + "-test-id");
            }
        }
    }

    public static void extractScopeFields(Object target) {
        SessionUtil.extractFields(target);
        ScopeTestUtil.getconversationManager().extractConversationFields(target, ConversationAdapter.getAdapter());
    }

    public static void injectScopeFields(Object target) {
        SessionUtil.injectFields(target);
        ScopeTestUtil.getconversationManager().injectConversationFields(target, ConversationAdapter.getAdapter());
    }

    static {
        arbitrator = new DefaultConversationArbitrator();
    }
}

