/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.util.RequestContextUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class StrutsConversationAdapter
extends ConversationAdapter {
    private static final long serialVersionUID = -907192380776385729L;
    protected ConversationContextManager conversationContextManager;
    protected ActionInvocation invocation;
    protected ActionContext actionContext;
    protected HttpServletRequest request;
    protected Map<String, String> requestContext;

    public StrutsConversationAdapter(ActionInvocation invocation, ConversationContextManager conversationContextManager) {
        this.invocation = invocation;
        this.actionContext = invocation.getInvocationContext();
        this.conversationContextManager = conversationContextManager;
    }

    @Override
    public Object getAction() {
        return this.invocation.getAction();
    }

    @Override
    public String getActionId() {
        return this.invocation.getProxy().getMethod();
    }

    @Override
    public Map<String, String> getRequestContext() {
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null) {
            HttpServletRequest currentRequest = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            if (!currentRequest.equals(this.request)) {
                this.request = currentRequest;
                this.requestContext = RequestContextUtil.getRequestContext(currentRequest);
            }
        } else {
            this.requestContext = new HashMap<String, String>();
        }
        return this.requestContext;
    }

    @Override
    public ConversationContext beginConversation(String conversationName, long maxIdleTimeMillis) {
        return this.conversationContextManager.createContext(conversationName, maxIdleTimeMillis);
    }

    @Override
    public ConversationContext getConversationContext(String conversationName, String conversationId) {
        return this.conversationContextManager.getContext(conversationName, conversationId);
    }

    @Override
    public ConversationContext endConversation(String conversationName, String conversationId) {
        return this.conversationContextManager.remove(conversationName, conversationId);
    }
}

