/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.ActionProvider;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.classloader.ReloadingClassLoader;
import com.opensymphony.xwork2.util.finder.ClassFinder;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import com.opensymphony.xwork2.util.finder.Test;
import com.opensymphony.xwork2.util.finder.UrlSet;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrutsActionProvider
implements ActionProvider {
    private static final long serialVersionUID = 6728107973559862449L;
    private static final Logger LOG = LoggerFactory.getLogger(StrutsActionProvider.class);
    private Set<Class<?>> actionClasses;
    private String[] actionPackages;
    private String[] packageLocators;
    private String[] includeJars;
    private boolean disablePackageLocatorsScanning;
    private boolean checkImplementsAction;
    private String packageLocatorsBasePackage;
    private String actionSuffix;
    private Set<String> fileProtocols;
    private boolean devMode;
    private ReloadingClassLoader reloadingClassLoader;
    private boolean reload;
    private boolean excludeParentClassLoader;
    private boolean requireFollowsConvention;

    @Override
    public Set<Class<?>> getActionClasses() {
        if (this.actionClasses == null) {
            this.initReloadClassLoader();
            this.actionClasses = this.findActions();
        }
        return this.actionClasses;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = "true".equals(mode);
    }

    @Inject(value="struts.convention.classes.reload")
    public void setReload(String reload) {
        this.reload = "true".equals(reload);
    }

    @Inject(value="struts.convention.exclude.parentClassLoader")
    public void setExcludeParentClassLoader(String exclude) {
        this.excludeParentClassLoader = "true".equals(exclude);
    }

    @Inject(value="struts.convention.action.fileProtocols")
    public void setFileProtocols(String fileProtocols) {
        if (StringUtils.isNotBlank((CharSequence)fileProtocols)) {
            this.fileProtocols = TextParseUtil.commaDelimitedStringToSet((String)fileProtocols);
        }
    }

    @Inject(value="struts.convention.action.includeJars", required=false)
    public void setIncludeJars(String includeJars) {
        if (StringUtils.isNotEmpty((CharSequence)includeJars)) {
            this.includeJars = includeJars.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.package.locators.disable", required=false)
    public void setDisablePackageLocatorsScanning(String disablePackageLocatorsScanning) {
        this.disablePackageLocatorsScanning = "true".equals(disablePackageLocatorsScanning);
    }

    @Inject(value="struts.convention.action.packages", required=false)
    public void setActionPackages(String actionPackages) {
        if (StringUtils.isNotBlank((CharSequence)actionPackages)) {
            this.actionPackages = actionPackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.action.checkImplementsAction", required=false)
    public void setCheckImplementsAction(String checkImplementsAction) {
        this.checkImplementsAction = "true".equals(checkImplementsAction);
    }

    @Inject(value="struts.convention.action.suffix", required=false)
    public void setActionSuffix(String actionSuffix) {
        if (StringUtils.isNotBlank((CharSequence)actionSuffix)) {
            this.actionSuffix = actionSuffix;
        }
    }

    @Inject(value="struts.convention.package.locators", required=false)
    public void setPackageLocators(String packageLocators) {
        this.packageLocators = packageLocators.split("\\s*[,]\\s*");
    }

    @Inject(value="struts.convention.package.locators.basePackage", required=false)
    public void setPackageLocatorsBase(String packageLocatorsBasePackage) {
        this.packageLocatorsBasePackage = packageLocatorsBasePackage;
    }

    @Inject(value="struts.scope.followsConvention")
    public void setRequireFollowsConvention(String requireFollowsConvention) {
        this.requireFollowsConvention = "true".equals(requireFollowsConvention);
    }

    protected boolean includeClassNameInActionScan(String className) {
        String classPackageName = StringUtils.substringBeforeLast((String)className, (String)".");
        if (this.actionPackages != null) {
            for (String packageName : this.actionPackages) {
                String strictPackageName = packageName + ".";
                if (!classPackageName.equals(packageName) && !classPackageName.startsWith(strictPackageName)) continue;
                return true;
            }
        }
        if (this.packageLocators != null && !this.disablePackageLocatorsScanning) {
            for (String packageLocator : this.packageLocators) {
                String[] splitted;
                if (classPackageName.length() <= 0 || this.packageLocatorsBasePackage != null && !classPackageName.startsWith(this.packageLocatorsBasePackage) || !StrutsActionProvider.contains(splitted = classPackageName.split("\\."), packageLocator, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected Test<String> getClassPackageTest() {
        return new Test<String>(){

            public boolean test(String className) {
                return StrutsActionProvider.this.includeClassNameInActionScan(className);
            }
        };
    }

    protected Test<ClassFinder.ClassInfo> getActionClassTest() {
        return new Test<ClassFinder.ClassInfo>(){

            public boolean test(ClassFinder.ClassInfo classInfo) {
                boolean inPackage = StrutsActionProvider.this.includeClassNameInActionScan(classInfo.getName());
                boolean nameMatches = classInfo.getName().endsWith(StrutsActionProvider.this.actionSuffix) || !StrutsActionProvider.this.requireFollowsConvention;
                try {
                    return inPackage && (nameMatches || StrutsActionProvider.this.checkImplementsAction && Action.class.isAssignableFrom(classInfo.get()));
                }
                catch (ClassNotFoundException ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Unable to load class [#0]", (Object)ex, (Object)classInfo.getName());
                    }
                    return false;
                }
            }
        };
    }

    protected Set<Class<?>> findActions() {
        HashSet classes;
        block4: {
            classes = new HashSet();
            try {
                if (this.actionPackages != null || this.packageLocators != null && !this.disablePackageLocatorsScanning) {
                    Test<String> classPackageTest = this.getClassPackageTest();
                    ClassFinder finder = new ClassFinder(this.getClassLoaderInterface(), (Collection)this.buildUrlSet().getUrls(), true, this.fileProtocols, classPackageTest);
                    Test<ClassFinder.ClassInfo> test = this.getActionClassTest();
                    for (Class clazz : finder.findClasses(test)) {
                        classes.add(clazz);
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("Unable to scan named packages", (Throwable)ex);
            }
        }
        return classes;
    }

    protected boolean isReloadEnabled() {
        return this.devMode && this.reload;
    }

    protected void initReloadClassLoader() {
        if (this.isReloadEnabled() && this.reloadingClassLoader == null) {
            this.reloadingClassLoader = new ReloadingClassLoader(this.getClassLoader());
        }
    }

    protected ClassLoaderInterface getClassLoaderInterface() {
        if (this.isReloadEnabled()) {
            return new ClassLoaderInterfaceDelegate((ClassLoader)this.reloadingClassLoader);
        }
        ClassLoaderInterface classLoaderInterface = null;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            classLoaderInterface = (ClassLoaderInterface)ctx.get("__current_class_loader_interface");
        }
        return (ClassLoaderInterface)ObjectUtils.defaultIfNull((Object)classLoaderInterface, (Object)new ClassLoaderInterfaceDelegate(this.getClassLoader()));
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private UrlSet buildUrlSet() throws IOException {
        UrlSet urlSet;
        block14: {
            ClassLoaderInterface classLoaderInterface;
            block13: {
                classLoaderInterface = this.getClassLoaderInterface();
                urlSet = new UrlSet(classLoaderInterface, this.fileProtocols);
                if (this.excludeParentClassLoader) {
                    ClassLoaderInterface parent = classLoaderInterface.getParent();
                    if (parent != null && this.isReloadEnabled()) {
                        parent = parent.getParent();
                    }
                    if (parent != null) {
                        urlSet = urlSet.exclude(parent);
                    }
                    try {
                        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                        urlSet = urlSet.exclude((ClassLoaderInterface)new ClassLoaderInterfaceDelegate(systemClassLoader.getParent()));
                    }
                    catch (SecurityException e) {
                        if (!LOG.isWarnEnabled()) break block13;
                        LOG.warn("Could not get the system classloader due to security constraints, there may be improper urls left to scan");
                    }
                }
            }
            urlSet = urlSet.includeClassesUrl(classLoaderInterface);
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaEndorsedDirs();
            try {
                urlSet = urlSet.excludeJavaHome();
            }
            catch (NullPointerException e) {
                if (!LOG.isWarnEnabled()) break block14;
                LOG.warn("Could not exclude JAVA_HOME, is this a sandbox jvm?");
            }
        }
        urlSet = urlSet.excludePaths(System.getProperty("sun.boot.class.path", ""));
        urlSet = urlSet.exclude(".*/JavaVM.framework/.*");
        if (this.includeJars != null) {
            List rawIncludedUrls = urlSet.getUrls();
            HashSet<URL> includeUrls = new HashSet<URL>();
            boolean[] patternUsed = new boolean[this.includeJars.length];
            block4: for (URL url : rawIncludedUrls) {
                if (this.fileProtocols.contains(url.getProtocol())) {
                    for (int i = 0; i < this.includeJars.length; ++i) {
                        String includeJar = this.includeJars[i];
                        if (!Pattern.matches(includeJar, url.toExternalForm())) continue;
                        includeUrls.add(url);
                        patternUsed[i] = true;
                        continue block4;
                    }
                    continue;
                }
                includeUrls.add(url);
            }
            if (LOG.isWarnEnabled()) {
                for (int i = 0; i < patternUsed.length; ++i) {
                    if (patternUsed[i]) continue;
                    LOG.warn("The includeJars pattern [#0] did not match any jars in the classpath", (Object)this.includeJars[i]);
                }
            }
            return new UrlSet(includeUrls);
        }
        urlSet = urlSet.exclude(".*?\\.jar(!/|/)?");
        return urlSet;
    }

    public static boolean contains(String[] strings, String value, boolean ignoreCase) {
        if (strings != null) {
            for (String string : strings) {
                if (!string.equals(value) && (!ignoreCase || !string.equalsIgnoreCase(value))) continue;
                return true;
            }
        }
        return false;
    }
}

