/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.ActionProvider;
import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.configuration.ConversationArbitrator;
import com.google.code.rees.scope.conversation.configuration.ConversationConfigurationProvider;
import com.google.code.rees.scope.conversation.context.ConversationContextFactory;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.conversation.context.HttpConversationContextManagerProvider;
import com.google.code.rees.scope.conversation.exceptions.ConversationException;
import com.google.code.rees.scope.conversation.exceptions.ConversationIdException;
import com.google.code.rees.scope.conversation.processing.ConversationProcessor;
import com.google.code.rees.scope.struts2.ConversationErrorAware;
import com.google.code.rees.scope.struts2.StrutsConversationAdapter;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationInterceptor
implements Interceptor,
PreResultListener {
    private static final long serialVersionUID = -72776817859403642L;
    private static final Logger LOG = LoggerFactory.getLogger(ConversationInterceptor.class);
    public static final String CONVERSATION_ID_EXCEPTION_KEY = "struts.conversation.invalid.id";
    public static final String CONVERSATION_EXCEPTION_KEY = "struts.conversation.general.error";
    public static final String CONVERSATION_EXCEPTION_NAME_STACK_KEY = "conversation.name";
    public static final String CONVERSATION_EXCEPTION_ID_STACK_KEY = "conversation.id";
    protected ActionProvider finder;
    protected String actionSuffix;
    protected long maxIdleTime;
    protected ConversationArbitrator arbitrator;
    protected ConversationConfigurationProvider conversationConfigurationProvider;
    protected ConversationProcessor conversationProcessor;
    protected HttpConversationContextManagerProvider conversationContextManagerProvider;
    protected int monitoringThreadPoolSize;
    protected long monitoringFrequency;
    protected int maxInstances;
    protected ConversationContextFactory conversationContextFactory;

    @Inject(value="struts.scope.actionFinder")
    public void setActionClassFinder(ActionProvider finder) {
        this.finder = finder;
    }

    @Inject(value="struts.convention.action.suffix")
    public void setActionSuffix(String suffix) {
        this.actionSuffix = suffix;
    }

    @Inject(value="conversation.idle.timeout")
    public void setDefaultMaxIdleTime(String defaultMaxIdleTimeString) {
        this.maxIdleTime = Long.parseLong(defaultMaxIdleTimeString);
    }

    @Inject(value="struts.conversation.arbitrator")
    public void setArbitrator(ConversationArbitrator arbitrator) {
        this.arbitrator = arbitrator;
    }

    @Inject(value="struts.conversation.configurationProvider")
    public void setConversationConfigurationProvider(ConversationConfigurationProvider conversationConfigurationProvider) {
        this.conversationConfigurationProvider = conversationConfigurationProvider;
    }

    @Inject(value="struts.conversation.conversationProcessor")
    public void setConversationManager(ConversationProcessor manager) {
        this.conversationProcessor = manager;
    }

    @Inject(value="conversation.context.manager.provider")
    public void setHttpConversationContextManagerProvider(HttpConversationContextManagerProvider conversationContextManagerProvider) {
        this.conversationContextManagerProvider = conversationContextManagerProvider;
    }

    @Inject(value="conversation.monitoring.thread.pool.size")
    public void setMonitoringThreadPoolSize(String monitoringThreadPoolSizeString) {
        this.monitoringThreadPoolSize = Integer.parseInt(monitoringThreadPoolSizeString);
    }

    @Inject(value="conversation.monitoring.frequency")
    public void setMonitoringFrequency(String monitoringFrequencyString) {
        this.monitoringFrequency = Long.parseLong(monitoringFrequencyString);
    }

    @Inject(value="conversation.max.instances")
    public void setMaxInstances(String maxInstancesString) {
        this.maxInstances = Integer.parseInt(maxInstancesString);
    }

    @Inject(value="conversation.context.factory")
    public void setConversationContextFactory(ConversationContextFactory conversationContextFactory) {
        this.conversationContextFactory = conversationContextFactory;
    }

    public void destroy() {
        LOG.info("Destroying the ConversationInterceptor...");
    }

    public void init() {
        LOG.info("Initializing the Conversation Interceptor...");
        this.arbitrator.setActionSuffix(this.actionSuffix);
        this.conversationConfigurationProvider.setArbitrator(this.arbitrator);
        this.conversationConfigurationProvider.setDefaultMaxIdleTime(this.maxIdleTime);
        this.conversationConfigurationProvider.init(this.finder.getActionClasses());
        this.conversationProcessor.setConfigurationProvider(this.conversationConfigurationProvider);
        this.conversationContextManagerProvider.setConversationContextFactory(this.conversationContextFactory);
        this.conversationContextManagerProvider.setMaxInstances(this.maxInstances);
        this.conversationContextManagerProvider.setMonitoringFrequency(this.monitoringFrequency);
        this.conversationContextManagerProvider.setMonitoringThreadPoolSize(this.monitoringThreadPoolSize);
        this.conversationContextManagerProvider.init();
        LOG.info("...Conversation Interceptor successfully initialized.");
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        ConversationContextManager contextManager = this.conversationContextManagerProvider.getManager(request);
        try {
            this.conversationProcessor.processConversations(new StrutsConversationAdapter(invocation, contextManager));
        }
        catch (ConversationIdException cie) {
            return this.handleIdException(invocation, cie);
        }
        catch (ConversationException ce) {
            return this.handleUnexpectedException(invocation, ce);
        }
        invocation.addPreResultListener((PreResultListener)this);
        return invocation.invoke();
    }

    public void beforeResult(ActionInvocation invocation, String result) {
        ConversationAdapter.getAdapter().executePostProcessors();
        invocation.getStack().getContext().put("conversationIdMapStackKey", ConversationAdapter.getAdapter().getViewContext());
    }

    protected String handleIdException(ActionInvocation invocation, ConversationIdException cie) {
        LOG.warn("ConversationIdException occurred in Conversation Processing, returning result of struts.conversation.invalid.id");
        Locale locale = invocation.getInvocationContext().getLocale();
        Map stackContext = invocation.getStack().getContext();
        stackContext.put(CONVERSATION_EXCEPTION_NAME_STACK_KEY, cie.getConversationName());
        stackContext.put(CONVERSATION_EXCEPTION_ID_STACK_KEY, cie.getConversationId());
        String conversationSpecificMessageKey = "struts.conversation.invalid.id." + cie.getConversationName();
        String errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)conversationSpecificMessageKey, (Locale)locale);
        if (errorMessage == null || errorMessage.equals(conversationSpecificMessageKey)) {
            errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)CONVERSATION_ID_EXCEPTION_KEY, (Locale)locale, (String)"The workflow that you are attempting to continue has ended or expired.  Your requested action was not processed.", (Object[])new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Placing Conversation Error Message on stack (key={struts.conversation.invalid.id}):  " + errorMessage);
        }
        stackContext.put(CONVERSATION_ID_EXCEPTION_KEY, errorMessage);
        this.handleConversationErrorAware(invocation.getProxy(), errorMessage);
        return CONVERSATION_ID_EXCEPTION_KEY;
    }

    protected String handleUnexpectedException(ActionInvocation invocation, ConversationException ce) {
        LOG.error("An unexpected exception occurred in Conversation Processing, returning result of struts.conversation.general.error");
        Locale locale = invocation.getInvocationContext().getLocale();
        String errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)CONVERSATION_EXCEPTION_KEY, (Locale)locale, (String)"An unexpected error occurred while processing you request.  Please try again.", (Object[])new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Placing Conversation Error Message on stack (key={struts.conversation.general.error}):  " + errorMessage);
        }
        invocation.getStack().getContext().put(CONVERSATION_EXCEPTION_KEY, errorMessage);
        this.handleConversationErrorAware(invocation.getProxy(), errorMessage);
        return CONVERSATION_EXCEPTION_KEY;
    }

    protected void handleConversationErrorAware(ActionProxy proxy, String errorMessage) {
        Object action = proxy.getAction();
        if (action instanceof ConversationErrorAware) {
            LOG.debug("Action is an instance of ConversationErrorAware; setting conversation error.");
            ((ConversationErrorAware)action).setConversationError(errorMessage);
        }
    }
}

