/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.configuration;

import com.google.code.rees.scope.conversation.ConversationUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConversationClassConfiguration {
    private Map<String, Field> fields = new HashMap<String, Field>();
    private Set<String> actionIds = new HashSet<String>();
    private Set<String> beginActionIds = new HashSet<String>();
    private Set<String> endActionIds = new HashSet<String>();
    private Map<String, Long> beginActionIdleTimes = new HashMap<String, Long>();
    private String conversationName;

    public ConversationClassConfiguration(String conversationName) {
        this.conversationName = ConversationUtil.sanitizeName(conversationName) + "_conversation";
    }

    public void addField(String name, Field field) {
        this.fields.put(name, field);
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public void addAction(String actionId) {
        this.actionIds.add(actionId);
    }

    public void addBeginAction(String actionId, Long maxIdleTimeMillis) {
        this.actionIds.add(actionId);
        this.beginActionIds.add(actionId);
        this.beginActionIdleTimes.put(actionId, maxIdleTimeMillis);
    }

    public void addEndAction(String actionId) {
        this.actionIds.add(actionId);
        this.endActionIds.add(actionId);
    }

    public boolean containsAction(String actionId) {
        return this.actionIds.contains(actionId);
    }

    public boolean isBeginAction(String actionId) {
        return this.beginActionIds.contains(actionId);
    }

    public boolean isEndAction(String actionId) {
        return this.endActionIds.contains(actionId);
    }

    public long getMaxIdleTime(String beginActionId) {
        return this.beginActionIdleTimes.get(beginActionId);
    }

    public String getConversationName() {
        return this.conversationName;
    }
}

