/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ConversationUtil {
    public static String getId(String conversationName) {
        if (!conversationName.endsWith("_conversation")) {
            conversationName = conversationName + "_conversation";
        }
        ConversationAdapter adapter = ConversationAdapter.getAdapter();
        String id = adapter.getRequestContext().get(conversationName);
        return id;
    }

    public static Object getField(String fieldName) {
        Object field;
        block1: {
            String id;
            Map.Entry<String, String> entry;
            String name;
            ConversationContext conversationContext;
            field = null;
            ConversationAdapter adapter = ConversationAdapter.getAdapter();
            if (adapter == null) break block1;
            Map<String, String> requestContext = adapter.getRequestContext();
            Iterator<Map.Entry<String, String>> i$ = requestContext.entrySet().iterator();
            while (i$.hasNext() && ((conversationContext = adapter.getConversationContext(name = (entry = i$.next()).getKey(), id = entry.getValue())) == null || (field = conversationContext.get(fieldName)) == null)) {
            }
        }
        return field;
    }

    public static <T> T getField(String fieldName, Class<T> fieldClass) {
        return ConversationUtil.getField(fieldName, fieldClass, ConversationUtil.getConversations());
    }

    public static <T> T getField(String fieldName, Class<T> fieldClass, String[] conversations) {
        T field = null;
        ConversationAdapter adapter = ConversationAdapter.getAdapter();
        if (adapter != null) {
            ConversationContext conversationContext;
            String conversationName;
            String id;
            String[] arr$ = conversations;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((id = ConversationUtil.getId(conversationName = arr$[i$])) == null || (conversationContext = adapter.getConversationContext(conversationName, id)) == null || (field = (T)conversationContext.get(fieldName)) == null); ++i$) {
            }
        }
        return field;
    }

    public static void setField(String fieldName, Object fieldValue) {
        ConversationAdapter adapter = ConversationAdapter.getAdapter();
        if (adapter != null) {
            Map<String, String> requestContext = adapter.getRequestContext();
            for (Map.Entry<String, String> entry : requestContext.entrySet()) {
                String id;
                String name = entry.getKey();
                ConversationContext conversationContext = adapter.getConversationContext(name, id = entry.getValue());
                if (conversationContext == null) continue;
                conversationContext.put(fieldName, fieldValue);
            }
        }
    }

    public static ConversationContext begin(String name, long maxIdleTimeMillis) {
        return ConversationUtil.begin(name, ConversationAdapter.getAdapter(), maxIdleTimeMillis);
    }

    public static ConversationContext begin(String name, ConversationAdapter adapter, long maxIdleTimeMillis) {
        ConversationContext context = adapter.beginConversation(name, maxIdleTimeMillis);
        String id = context.getId();
        adapter.getViewContext().put(name, id);
        adapter.getRequestContext().put(name, id);
        return context;
    }

    public static ConversationContext persist(String name) {
        return ConversationUtil.persist(name, ConversationAdapter.getAdapter());
    }

    public static ConversationContext persist(String name, ConversationAdapter adapter) {
        String id = adapter.getRequestContext().get(name);
        if (id == null) {
            return null;
        }
        adapter.getViewContext().put(name, id);
        return adapter.getConversationContext(name, id);
    }

    public static ConversationContext end(String name) {
        return ConversationUtil.end(name, ConversationAdapter.getAdapter());
    }

    public static ConversationContext end(String name, ConversationAdapter adapter) {
        String id = adapter.getRequestContext().remove(name);
        if (id == null) {
            return null;
        }
        adapter.getViewContext().remove(name);
        return adapter.endConversation(name, id);
    }

    public static ConversationContext getContext(String name) {
        ConversationAdapter adapter = ConversationAdapter.getAdapter();
        String id = adapter.getRequestContext().get(name);
        if (id == null) {
            return null;
        }
        return adapter.getConversationContext(name, id);
    }

    public static String[] getConversations() {
        ArrayList<String> convoIds = new ArrayList<String>();
        ConversationAdapter adapter = ConversationAdapter.getAdapter();
        if (adapter != null) {
            Map<String, String> requestContext = adapter.getRequestContext();
            convoIds.addAll(requestContext.keySet());
        }
        return convoIds.toArray(new String[convoIds.size()]);
    }

    public static String[] getIds() {
        ArrayList<String> convoIds = new ArrayList<String>();
        ConversationAdapter adapter = ConversationAdapter.getAdapter();
        if (adapter != null) {
            Map<String, String> requestContext = adapter.getRequestContext();
            convoIds.addAll(requestContext.values());
        }
        return convoIds.toArray(new String[convoIds.size()]);
    }

    public static String sanitizeName(String conversationName) {
        return conversationName.replaceAll(":", "").replaceAll(",", "");
    }
}

