/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation;

import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.processing.ConversationPostProcessor;
import com.google.code.rees.scope.conversation.processing.ConversationPostProcessorWrapper;
import com.google.code.rees.scope.conversation.processing.ConversationPostProcessorWrapperFactory;
import com.google.code.rees.scope.conversation.processing.DefaultConversationPostProcessorWrapperFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class ConversationAdapter
implements Serializable {
    private static final long serialVersionUID = -8006640931436858515L;
    protected static ThreadLocal<ConversationAdapter> conversationAdapter = new ThreadLocal();
    protected Map<String, String> viewContext = new HashMap<String, String>();
    protected ConversationPostProcessorWrapperFactory postProcessorFactory = new DefaultConversationPostProcessorWrapperFactory();
    protected Collection<ConversationPostProcessorWrapper> postProcessors = new HashSet<ConversationPostProcessorWrapper>();

    public ConversationAdapter() {
        conversationAdapter.set(this);
    }

    public abstract Object getAction();

    public abstract String getActionId();

    public abstract Map<String, String> getRequestContext();

    public abstract ConversationContext beginConversation(String var1, long var2);

    public abstract ConversationContext getConversationContext(String var1, String var2);

    public abstract ConversationContext endConversation(String var1, String var2);

    public Map<String, String> getViewContext() {
        return this.viewContext;
    }

    public void addPostProcessor(ConversationPostProcessor postProcessor, ConversationClassConfiguration conversationConfig, String conversationId) {
        ConversationPostProcessorWrapper wrapper = this.postProcessorFactory.create(this, postProcessor, conversationConfig, conversationId);
        this.postProcessors.add(wrapper);
    }

    public void executePostProcessors() {
        for (ConversationPostProcessorWrapper postProcessor : this.postProcessors) {
            postProcessor.postProcessConversation();
        }
    }

    public static void setAdapter(ConversationAdapter adapter) {
        conversationAdapter.set(adapter);
    }

    public static ConversationAdapter getAdapter() {
        return conversationAdapter.get();
    }
}

