/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NSDictionary
extends NSObject {
    private HashMap<String, NSObject> dict = new LinkedHashMap<String, NSObject>();

    public NSObject objectForKey(String key) {
        return this.dict.get(key);
    }

    public void put(String key, NSObject obj) {
        this.dict.put(key, obj);
    }

    public void put(String key, String obj) {
        this.put(key, new NSString(obj));
    }

    public void put(String key, int obj) {
        this.put(key, new NSNumber(obj));
    }

    public void put(String key, long obj) {
        this.put(key, new NSNumber(obj));
    }

    public void put(String key, double obj) {
        this.put(key, new NSNumber(obj));
    }

    public void put(String key, boolean obj) {
        this.put(key, new NSNumber(obj));
    }

    public void put(String key, Date obj) {
        this.put(key, new NSDate(obj));
    }

    public void put(String key, byte[] obj) {
        this.put(key, new NSData(obj));
    }

    public void remove(String key) {
        this.dict.remove(key);
    }

    public int count() {
        return this.dict.size();
    }

    public boolean equals(Object obj) {
        return obj.getClass().equals(this.getClass()) && ((NSDictionary)obj).dict.equals(this.dict);
    }

    public String[] allKeys() {
        return this.dict.keySet().toArray(new String[0]);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.dict != null ? this.dict.hashCode() : 0);
        return hash;
    }

    void toXML(StringBuilder xml, int level) {
        this.indent(xml, level);
        xml.append("<dict>");
        xml.append(NSObject.NEWLINE);
        for (String key : this.dict.keySet()) {
            NSObject val = this.objectForKey(key);
            this.indent(xml, level + 1);
            xml.append("<key>");
            if (key.contains("&") || key.contains("<") || key.contains(">")) {
                xml.append("<![CDATA[");
                xml.append(key.replaceAll("]]>", "]]]]><![CDATA[>"));
                xml.append("]]>");
            } else {
                xml.append(key);
            }
            xml.append("</key>");
            xml.append(NSObject.NEWLINE);
            val.toXML(xml, level + 1);
            xml.append(NSObject.NEWLINE);
        }
        this.indent(xml, level);
        xml.append("</dict>");
    }

    void assignIDs(BinaryPropertyListWriter out) {
        super.assignIDs(out);
        for (Map.Entry<String, NSObject> entry : this.dict.entrySet()) {
            new NSString(entry.getKey()).assignIDs(out);
            entry.getValue().assignIDs(out);
        }
    }

    void toBinary(BinaryPropertyListWriter out) throws IOException {
        out.writeIntHeader(13, this.dict.size());
        Set<Map.Entry<String, NSObject>> entries = this.dict.entrySet();
        for (Map.Entry<String, NSObject> entry : entries) {
            out.writeID(out.getID(new NSString(entry.getKey())));
        }
        for (Map.Entry<String, NSObject> entry : entries) {
            out.writeID(out.getID(entry.getValue()));
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCII(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder ascii = new StringBuilder();
        this.toASCIIGnuStep(ascii, 0);
        ascii.append(NEWLINE);
        return ascii.toString();
    }

    protected void toASCII(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append('{');
        ascii.append(NSObject.NEWLINE);
        String[] keys = this.dict.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            NSObject val = this.objectForKey(key);
            this.indent(ascii, level + 1);
            ascii.append("\"");
            ascii.append(NSString.escapeStringForASCII(key));
            ascii.append("\" =");
            Class<?> objClass = val.getClass();
            if (objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) {
                ascii.append(NEWLINE);
                val.toASCII(ascii, level + 2);
            } else {
                ascii.append(" ");
                val.toASCII(ascii, 0);
            }
            ascii.append(';');
            if (i != keys.length - 1) {
                ascii.append(NEWLINE);
                continue;
            }
            if (!objClass.equals(NSDictionary.class) && !objClass.equals(NSArray.class) && !objClass.equals(NSData.class)) continue;
            ascii.append(NEWLINE);
            this.indent(ascii, level);
        }
        ascii.append('}');
    }

    protected void toASCIIGnuStep(StringBuilder ascii, int level) {
        this.indent(ascii, level);
        ascii.append('{');
        ascii.append(NSObject.NEWLINE);
        String[] keys = this.dict.keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            NSObject val = this.objectForKey(key);
            this.indent(ascii, level + 1);
            ascii.append("\"");
            ascii.append(NSString.escapeStringForASCII(key));
            ascii.append("\" =");
            Class<?> objClass = val.getClass();
            if (objClass.equals(NSDictionary.class) || objClass.equals(NSArray.class) || objClass.equals(NSData.class)) {
                ascii.append(NEWLINE);
                val.toASCIIGnuStep(ascii, level + 2);
            } else {
                ascii.append(" ");
                val.toASCIIGnuStep(ascii, 0);
            }
            ascii.append(';');
            if (i != keys.length - 1) {
                ascii.append(NEWLINE);
                continue;
            }
            if (!objClass.equals(NSDictionary.class) && !objClass.equals(NSArray.class) && !objClass.equals(NSData.class)) continue;
            ascii.append(NEWLINE);
            this.indent(ascii, level);
        }
        ascii.append('}');
    }
}

