/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.jsonpool;

import com.googlecode.openbox.jsonpool.JsonStoreLoader;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractJsonStoreLoader<K, V>
implements JsonStoreLoader<K, V> {
    private final Map<K, Boolean> LOAD_INDEX = new HashMap<K, Boolean>(3);
    private final Map<K, Integer> NUM = new HashMap<K, Integer>(3);

    AbstractJsonStoreLoader() {
    }

    @Override
    public int getCurrentNum(K dc) {
        return this.NUM.containsKey(dc) ? this.NUM.get(dc) : 0;
    }

    @Override
    public V load(K dc) {
        return this.load(dc, 1).get(0);
    }

    @Override
    public synchronized List<V> load(K dc, int num) {
        try {
            if (this.hasLoaded(dc)) {
                return this.getJsonObjectsFromProvider(dc, num);
            }
            if (!this.LOAD_INDEX.containsKey(dc)) {
                this.LOAD_INDEX.put(dc, Boolean.TRUE);
            }
            if (this.hasStoreFile(dc)) {
                List<V> list = this.loadJsonObjectFromStore(dc);
                if (list.size() >= num) {
                    num = list.size();
                } else {
                    int needIncreaseNum = num - list.size();
                    List<V> newJsonObjs = this.getJsonObjectsFromProvider(dc, needIncreaseNum);
                    for (V jsonObj : newJsonObjs) {
                        list.add(jsonObj);
                    }
                }
                return list;
            }
            return this.getJsonObjectsFromProvider(dc, num);
        }
        catch (Exception e) {
            throw new RuntimeException("load Json object failed !", e);
        }
    }

    protected void sumNum(K dc, int userNum) {
        this.NUM.put(dc, this.getCurrentNum(dc) + userNum);
    }

    @Override
    public boolean hasStoreFile(K dc) {
        String filePath = this.getStorePath(dc);
        File file = new File(filePath);
        return file.exists();
    }

    @Override
    public boolean hasLoaded(K dc) {
        return this.LOAD_INDEX.containsKey(dc);
    }

    protected abstract List<V> loadJsonObjectFromStore(K var1);

    protected abstract List<V> getJsonObjectsFromProvider(K var1, int var2);
}

