/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mavenfilesync;

import com.googlecode.mavenfilesync.FileSyncMapping;
import com.googlecode.mavenfilesync.SettingsBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FileSyncSetupMojo
extends AbstractMojo {
    private static final String SETTINGS_FILENAME = ".settings/de.loskutov.FileSync.prefs";
    private static final String BUILDER_NAME = "de.loskutov.FileSync.FSBuilder";
    File projectDirectory;
    private final String defaultDestination;
    private final String defaultVariables;
    private boolean includeTeamPrivateFiles;
    private boolean useCurrentDateForDestinationFiles;
    private final boolean override;
    private boolean skip;
    private final FileSyncMapping[] mappings = new FileSyncMapping[0];

    public FileSyncSetupMojo() {
        this.defaultDestination = "";
        this.defaultVariables = "";
        this.projectDirectory = new File("");
        this.override = true;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Filesync generation skipped.");
        } else if (this.addFilesyncBuildCommandToEclipseProject()) {
            this.generateSettings();
        }
    }

    private boolean addFilesyncBuildCommandToEclipseProject() throws MojoExecutionException {
        File projectFile = new File(this.projectDirectory, ".project");
        if (!projectFile.exists()) {
            this.getLog().info((CharSequence)"No Eclipse .project file found. First import the maven project in Eclipse.");
            return false;
        }
        try {
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new FileReader(projectFile));
            Xpp3Dom buildSpec = dom.getChild("buildSpec");
            if (buildSpec != null) {
                Xpp3Dom[] buildCommands = buildSpec.getChildren("buildCommand");
                boolean hasFSBuildCommand = false;
                for (Xpp3Dom buildCommand : buildCommands) {
                    if (!BUILDER_NAME.equals(buildCommand.getChild("name").getValue())) continue;
                    hasFSBuildCommand = true;
                    break;
                }
                if (!hasFSBuildCommand) {
                    Xpp3Dom buildCommand = new Xpp3Dom("buildCommand");
                    Xpp3Dom name = new Xpp3Dom("name");
                    name.setValue(BUILDER_NAME);
                    buildCommand.addChild(name);
                    Xpp3Dom arguments = new Xpp3Dom("arguments");
                    arguments.setValue("");
                    buildCommand.addChild(arguments);
                    buildSpec.addChild(buildCommand);
                    FileWriter writer = new FileWriter(projectFile);
                    Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
                    writer.close();
                    this.getLog().info((CharSequence)"The filesync build command has been added to the eclipse .project file.");
                } else {
                    this.getLog().info((CharSequence)"The .project file has not been changed. Filesync build command is already present in the eclipse .project file.");
                }
                return true;
            }
            throw new MojoExecutionException("Malformed .project file: <buildSpec> section expected but not found.");
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void generateSettings() throws MojoExecutionException {
        if (this.projectDirectory == null) {
            throw new IllegalStateException("Unexpected state: project directory was supposed to be given by maven, but it is null.");
        }
        String settingsFilename = this.projectDirectory + "/" + SETTINGS_FILENAME;
        File settingsFile = new File(settingsFilename);
        if (settingsFile.exists() && !this.override) {
            this.getLog().info((CharSequence)"Skiping setting generation as settings file already exists and override set to false");
        } else {
            SettingsBuilder settings = new SettingsBuilder();
            settings.with(Param.DEFAULT_DESTINATION, this.defaultDestination);
            settings.with(Param.DEFAULT_VARIABLES, this.defaultVariables);
            settings.with(Param.ECLIPSE_PREFERENCES_VERSION, "1");
            settings.with(Param.INCLUDE_TEAM_PRIVATE_FILES, this.includeTeamPrivateFiles);
            if (this.mappings != null) {
                for (FileSyncMapping mapping : this.mappings) {
                    settings.withMapping(mapping);
                }
            }
            settings.with(Param.USE_CURRENT_DATE_FOR_DESTINATION_FILES, this.useCurrentDateForDestinationFiles);
            OutputStreamWriter fileWriter = null;
            try {
                if (!settingsFile.getParentFile().exists() && !settingsFile.getParentFile().mkdirs()) {
                    throw new MojoExecutionException("Cannot access or create Eclipse .settings folder (" + settingsFile.getParent() + ")");
                }
                fileWriter = new FileWriter(settingsFile);
                fileWriter.write(settings.build());
                this.getLog().info((CharSequence)("The settings file generated: " + settingsFilename + "."));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write to settings file (" + settingsFilename + "). ", (Exception)e);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to close stream.", e);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Param {
        DEFAULT_DESTINATION("defaultDestination"),
        DEFAULT_VARIABLES("defaultVariables"),
        ECLIPSE_PREFERENCES_VERSION("eclipse.preferences.version"),
        INCLUDE_TEAM_PRIVATE_FILES("includeTeamPrivateFiles"),
        USE_CURRENT_DATE_FOR_DESTINATION_FILES("useCurrentDateForDestinationFiles");

        private final String name;

        private Param(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

