/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;

public class LinkedSparseMatrix
extends AbstractMatrix {
    private static final Logger log = Logger.getLogger(LinkedSparseMatrix.class.getName());
    Linked links;

    protected LinkedSparseMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.links = new Linked();
    }

    protected LinkedSparseMatrix(Matrix A) {
        super(A);
        this.links = new Linked();
        this.set(A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedSparseMatrix(MatrixVectorReader r) throws IOException {
        super(0, 0);
        try {
            MatrixInfo info = r.readMatrixInfo();
            if (info.isComplex()) {
                throw new IllegalArgumentException("complex matrices not supported");
            }
            if (!info.isCoordinate()) {
                throw new IllegalArgumentException("only coordinate matrices supported");
            }
            MatrixSize size = r.readMatrixSize(info);
            this.numRows = size.numRows();
            this.numColumns = size.numColumns();
            this.links = new Linked();
            int nz = size.numEntries();
            int[] row = new int[nz];
            int[] column = new int[nz];
            double[] entry = new double[nz];
            r.readCoordinate(row, column, entry);
            r.add(-1, row);
            r.add(-1, column);
            for (int i = 0; i < nz; ++i) {
                this.set(row[i], column[i], entry[i]);
            }
        }
        finally {
            r.close();
        }
    }

    @Override
    public Matrix zero() {
        this.links = new Linked();
        return this;
    }

    @Override
    public double get(int row, int column) {
        return this.links.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        this.links.set(row, column, value);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new Iterator<MatrixEntry>(){
            Node cur;
            ReusableMatrixEntry entry;
            {
                this.cur = LinkedSparseMatrix.this.links.head;
                this.entry = new ReusableMatrixEntry();
            }

            @Override
            public boolean hasNext() {
                return this.cur != null;
            }

            @Override
            public MatrixEntry next() {
                this.entry.row = this.cur.row;
                this.entry.col = this.cur.col;
                this.entry.val = this.cur.val;
                this.cur = this.cur.rowTail;
                return this.entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("TODO");
            }
        };
    }

    @Override
    public Matrix scale(double alpha) {
        if (alpha == 0.0) {
            this.zero();
        } else if (alpha != 1.0) {
            for (MatrixEntry e : this) {
                this.set(e.row(), e.column(), e.get() * alpha);
            }
        }
        return this;
    }

    @Override
    public Matrix copy() {
        return new LinkedSparseMatrix(this);
    }

    @Override
    public Matrix transpose() {
        Linked old = this.links;
        this.numRows = this.numColumns;
        this.numColumns = old.rows.length;
        this.links = new Linked();
        Node node = old.head;
        while (node != null) {
            this.set(node.col, node.row, node.val);
            node = node.rowTail;
        }
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        this.checkMultAdd(x, y);
        if (alpha == 0.0) {
            return y;
        }
        Node node = this.links.head;
        while (node != null) {
            y.add(node.row, alpha * node.val * x.get(node.col));
            node = node.rowTail;
        }
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        this.checkTransMultAdd(x, y);
        if (alpha == 0.0) {
            return y;
        }
        Node node = this.links.head;
        while (node != null) {
            y.add(node.col, alpha * node.val * x.get(node.row));
            node = node.colTail;
        }
        return y;
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B, Matrix C) {
        this.checkMultAdd(B, C);
        if (alpha == 0.0) {
            return C;
        }
        for (int i = 0; i < this.numRows; ++i) {
            Node row = this.links.startOfRow(i);
            if (row == null) continue;
            for (int j = 0; j < B.numColumns(); ++j) {
                Node node = row;
                double v = 0.0;
                while (node != null && node.row == i) {
                    v += B.get(node.col, j) * node.val;
                    node = node.rowTail;
                }
                if (v == 0.0) continue;
                C.add(i, j, alpha * v);
            }
        }
        return C;
    }

    @Override
    public Matrix transBmultAdd(double alpha, Matrix B, Matrix C) {
        this.checkTransBmultAdd(B, C);
        if (alpha == 0.0) {
            return C;
        }
        for (int i = 0; i < this.numRows; ++i) {
            Node row = this.links.startOfRow(i);
            if (row == null) continue;
            for (int j = 0; j < B.numRows(); ++j) {
                Node node = row;
                double v = 0.0;
                while (node != null && node.row == i) {
                    v += B.get(j, node.col) * node.val;
                    node = node.rowTail;
                }
                if (v == 0.0) continue;
                C.add(i, j, alpha * v);
            }
        }
        return C;
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B, Matrix C) {
        this.checkTransAmultAdd(B, C);
        if (alpha == 0.0) {
            return C;
        }
        for (int i = 0; i < this.numColumns; ++i) {
            Node row = this.links.startOfCol(i);
            if (row == null) continue;
            for (int j = 0; j < B.numColumns(); ++j) {
                Node node = row;
                double v = 0.0;
                while (node != null && node.col == i) {
                    v += B.get(node.row, j) * node.val;
                    node = node.colTail;
                }
                if (v == 0.0) continue;
                C.add(i, j, alpha * v);
            }
        }
        return C;
    }

    @Override
    public Matrix transABmultAdd(double alpha, Matrix B, Matrix C) {
        this.checkTransABmultAdd(B, C);
        if (alpha == 0.0) {
            return C;
        }
        for (int i = 0; i < this.numColumns; ++i) {
            Node row = this.links.startOfCol(i);
            if (row == null) continue;
            for (int j = 0; j < B.numRows(); ++j) {
                Node node = row;
                double v = 0.0;
                while (node != null && node.col == i) {
                    v += B.get(j, node.row) * node.val;
                    node = node.colTail;
                }
                if (v == 0.0) continue;
                C.add(i, j, alpha * v);
            }
        }
        return C;
    }

    static /* synthetic */ int access$000(LinkedSparseMatrix x0) {
        return x0.numRows;
    }

    static /* synthetic */ int access$100(LinkedSparseMatrix x0) {
        return x0.numColumns;
    }

    static class ReusableMatrixEntry
    implements MatrixEntry {
        int row;
        int col;
        double val;

        ReusableMatrixEntry() {
        }

        @Override
        public int column() {
            return this.col;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public double get() {
            return this.val;
        }

        @Override
        public void set(double value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.row + "," + this.col + "=" + this.val;
        }
    }

    class Linked {
        final Node head = new Node(0, 0, 0.0, null, null);
        Node[] rows = new Node[LinkedSparseMatrix.access$000(LinkedSparseMatrix.this)];
        Node[] cols = new Node[LinkedSparseMatrix.access$100(LinkedSparseMatrix.this)];

        Linked() {
        }

        private boolean isHead(int row, int col) {
            return this.head.row == row && this.head.col == col;
        }

        private boolean isNextByRow(Node node, int row, int col) {
            return node != null && node.rowTail != null && node.rowTail.row == row && node.rowTail.col == col;
        }

        private boolean isNextByCol(Node node, int row, int col) {
            return node != null && node.colTail != null && node.colTail.col == col && node.colTail.row == row;
        }

        public double get(int row, int col) {
            if (this.isHead(row, col)) {
                return this.head.val;
            }
            if (col <= row) {
                Node node = this.findPreceedingByRow(row, col);
                if (this.isNextByRow(node, row, col)) {
                    return node.rowTail.val;
                }
            } else {
                Node node = this.findPreceedingByCol(row, col);
                if (this.isNextByCol(node, row, col)) {
                    return node.colTail.val;
                }
            }
            return 0.0;
        }

        public void set(int row, int col, double val) {
            if (val == 0.0) {
                this.delete(row, col);
                return;
            }
            if (this.isHead(row, col)) {
                this.head.val = val;
            } else {
                Node prevRow = this.findPreceedingByRow(row, col);
                if (this.isNextByRow(prevRow, row, col)) {
                    prevRow.rowTail.val = val;
                } else {
                    Node prevCol = this.findPreceedingByCol(row, col);
                    Node nextCol = this.findNextByCol(row, col);
                    prevCol.colTail = prevRow.rowTail = new Node(row, col, val, prevRow.rowTail, nextCol);
                    this.updateCache(prevRow.rowTail);
                }
            }
            if (this.isHead(row, col)) {
                assert (this.head.val == val);
            } else {
                Node node = this.findPreceedingByCol(row, col);
                assert (node != null);
                assert (node.colTail.val == val);
            }
        }

        private Node findNextByCol(int row, int col) {
            Node cur = this.cachedByCol(col - 1);
            while (cur != null) {
                if (row < cur.row && col <= cur.col || col < cur.col) {
                    return cur;
                }
                cur = cur.colTail;
            }
            return cur;
        }

        private void updateCache(Node inserted) {
            if (this.rows[inserted.row] == null || inserted.col > this.rows[inserted.row].col) {
                this.rows[inserted.row] = inserted;
            }
            if (this.cols[inserted.col] == null || inserted.row > this.cols[inserted.col].row) {
                this.cols[inserted.col] = inserted;
            }
        }

        private void delete(int row, int col) {
            if (this.isHead(row, col)) {
                this.head.val = 0.0;
                return;
            }
            Node precRow = this.findPreceedingByRow(row, col);
            Node precCol = this.findPreceedingByCol(row, col);
            if (this.isNextByRow(precRow, row, col)) {
                if (this.rows[row] == precRow.rowTail) {
                    this.rows[row] = precRow.row == row ? precRow : null;
                }
                precRow.rowTail = precRow.rowTail.rowTail;
            }
            if (this.isNextByCol(precCol, row, col)) {
                if (this.cols[col] == precCol.colTail) {
                    this.cols[col] = precCol.col == col ? precCol : null;
                }
                precCol.colTail = precCol.colTail.colTail;
            }
        }

        Node findPreceedingByRow(int row, int col) {
            Node last;
            Node cur = last = this.cachedByRow(row - 1);
            while (cur != null && cur.row <= row) {
                if (cur.row == row && cur.col >= col) {
                    return last;
                }
                last = cur;
                cur = cur.rowTail;
            }
            return last;
        }

        private Node cachedByRow(int row) {
            for (int i = row; i >= 0; --i) {
                if (this.rows[i] == null) continue;
                return this.rows[i];
            }
            return this.head;
        }

        Node findPreceedingByCol(int row, int col) {
            Node last;
            Node cur = last = this.cachedByCol(col - 1);
            while (cur != null && cur.col <= col) {
                if (cur.col == col && cur.row >= row) {
                    return last;
                }
                last = cur;
                cur = cur.colTail;
            }
            return last;
        }

        private Node cachedByCol(int col) {
            for (int i = col; i >= 0; --i) {
                if (this.cols[i] == null) continue;
                return this.cols[i];
            }
            return this.head;
        }

        Node startOfRow(int row) {
            if (row == 0) {
                return this.head;
            }
            Node prec = this.findPreceedingByRow(row, 0);
            if (prec.rowTail != null && prec.rowTail.row == row) {
                return prec.rowTail;
            }
            return null;
        }

        Node startOfCol(int col) {
            if (col == 0) {
                return this.head;
            }
            Node prec = this.findPreceedingByCol(0, col);
            if (prec != null && prec.colTail != null && prec.colTail.col == col) {
                return prec.colTail;
            }
            return null;
        }
    }

    static class Node {
        final int row;
        final int col;
        double val;
        Node rowTail;
        Node colTail;

        @ConstructorProperties(value={"row", "col", "val", "rowTail", "colTail"})
        public Node(int row, int col, double val, Node rowTail, Node colTail) {
            this.row = row;
            this.col = col;
            this.val = val;
            this.rowTail = rowTail;
            this.colTail = colTail;
        }

        public String toString() {
            return "LinkedSparseMatrix.Node(row=" + this.row + ", col=" + this.col + ", val=" + this.val + ")";
        }
    }
}

